/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.jdt.internal.core.classpath;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.virgo.ide.jdt.core.JdtCorePlugin;
import org.eclipse.virgo.ide.runtime.core.ServerCorePlugin;
import org.eclipse.virgo.util.io.FileCopyUtils;

class ServerClasspathUtils {
    private static final String CLASSPATH_FILE = "-org.eclipse.virgo.ide.jdt.core.xml";

    ServerClasspathUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void saveFile(IJavaProject project, StringBuilder builder) {
        File file = new File(ServerCorePlugin.getDefault().getStateLocation().toFile(), String.valueOf(project.getProject().getName()) + CLASSPATH_FILE);
        FileOutputStream os = null;
        try {
            file.createNewFile();
            os = new FileOutputStream(file);
            os.write(builder.toString().getBytes("UTF-8"));
            os.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (os == null) return;
            try {
                os.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException e) {
            try {
                JdtCorePlugin.log("Cannot save classpath entries to '" + file.getAbsolutePath() + "'", e);
                if (os == null) return;
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                os.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (os == null) return;
        try {
            os.close();
            return;
        }
        catch (IOException iOException) {}
    }

    protected static void persistClasspathEntries(IJavaProject project, IClasspathEntry[] entries) {
        String lineSeparator = Util.getLineSeparator(null, (IJavaProject)project);
        StringBuilder builder = new StringBuilder("<classpath>").append(lineSeparator);
        if (project instanceof JavaProject) {
            JavaProject javaProject = (JavaProject)project;
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                builder.append(javaProject.encodeClasspathEntry(entry));
                ++n2;
            }
        }
        builder.append("</classpath>").append(lineSeparator);
        ServerClasspathUtils.saveFile(project, builder);
    }

    protected static IClasspathEntry[] readPersistedClasspathEntries(IJavaProject project) {
        File file = new File(ServerCorePlugin.getDefault().getStateLocation().toFile(), String.valueOf(project.getProject().getName()) + CLASSPATH_FILE);
        String xmlClasspath = null;
        if (file.exists()) {
            try {
                byte[] bytes = FileCopyUtils.copyToByteArray((File)file);
                xmlClasspath = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (IOException iOException) {}
        }
        if (xmlClasspath == null) {
            return null;
        }
        if (project instanceof JavaProject) {
            JavaProject javaProject = (JavaProject)project;
            try {
                try {
                    Method method = javaProject.getClass().getMethod("decodeClasspath", String.class, Map.class);
                    Object decodedClassPath = method.invoke((Object)javaProject, xmlClasspath, new HashMap());
                    if (decodedClassPath instanceof IClasspathEntry[][]) {
                        ArrayList<IClasspathEntry> decodedEntries = new ArrayList<IClasspathEntry>();
                        IClasspathEntry[][] iClasspathEntryArray = (IClasspathEntry[][])decodedClassPath;
                        int n = iClasspathEntryArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IClasspathEntry[] entry = iClasspathEntryArray[n2];
                            decodedEntries.addAll(Arrays.asList(entry));
                            ++n2;
                        }
                        return decodedEntries.toArray(new IClasspathEntry[decodedEntries.size()]);
                    }
                    if (decodedClassPath instanceof IClasspathEntry[]) {
                        return (IClasspathEntry[])decodedClassPath;
                    }
                }
                catch (Exception e) {
                    JdtCorePlugin.log(e);
                }
            }
            catch (AssertionFailedException e) {
                JdtCorePlugin.log(e);
            }
        }
        return null;
    }
}

