/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.ServerOutlinePage;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.ServerProject;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;
import org.eclipse.wst.server.ui.internal.editor.ServerEditor;

public class VirgoEditorAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IContentOutlinePage.class && adaptableObject instanceof ServerEditor && VirgoEditorAdapterFactory.getVirgoServer((IEditorPart)adaptableObject) != null) {
            return new ServerOutlinePage((ServerEditor)adaptableObject);
        }
        return null;
    }

    public static IServer getVirgoServer(IEditorPart part) {
        IServer server = VirgoEditorAdapterFactory.getServer(part);
        if (ServerProject.isVirgo((IServer)server)) {
            return server;
        }
        return null;
    }

    public static IServer getServer(IEditorPart part) {
        if (part instanceof ServerEditor) {
            try {
                IServerWorkingCopy serverEditor;
                Method method = MultiPageEditorPart.class.getDeclaredMethod("getActiveEditor", new Class[0]);
                method.setAccessible(true);
                Object result = method.invoke((Object)part, new Object[0]);
                if (result instanceof ServerEditorPart && (serverEditor = ((ServerEditorPart)result).getServer()) != null) {
                    IServer server = serverEditor.getOriginal();
                    return server;
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IContentOutlinePage.class};
    }
}

