/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.floatingpoint.FloatDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.junit.Assert;
import org.junit.Test;

public class FloatDeclarationParserTest {
    @Test
    public void testCTF2Float32Parsing() throws Exception {
        CTFTrace trace = new CTFTrace();
        JsonObject fieldClass = new JsonObject();
        fieldClass.add("length", (JsonElement)new JsonPrimitive((Number)32));
        fieldClass.add("byte-order", (JsonElement)new JsonPrimitive("le"));
        JsonStructureFieldMemberMetadataNode node = new JsonStructureFieldMemberMetadataNode(null, "test", "test", "float_field", fieldClass);
        FloatDeclaration result = FloatDeclarationParser.INSTANCE.parse((ICTFMetadataNode)node, (ICommonTreeParser.ICommonTreeParserParameter)new FloatDeclarationParser.Param(trace));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)8L, (long)result.getExponent());
        Assert.assertEquals((long)24L, (long)result.getMantissa());
        Assert.assertEquals((Object)ByteOrder.LITTLE_ENDIAN, (Object)result.getByteOrder());
    }

    @Test
    public void testCTF2Float64Parsing() throws Exception {
        CTFTrace trace = new CTFTrace();
        JsonObject fieldClass = new JsonObject();
        fieldClass.add("length", (JsonElement)new JsonPrimitive((Number)64));
        fieldClass.add("byte-order", (JsonElement)new JsonPrimitive("be"));
        fieldClass.add("alignment", (JsonElement)new JsonPrimitive((Number)8));
        JsonStructureFieldMemberMetadataNode node = new JsonStructureFieldMemberMetadataNode(null, "test", "test", "double_field", fieldClass);
        FloatDeclaration result = FloatDeclarationParser.INSTANCE.parse((ICTFMetadataNode)node, (ICommonTreeParser.ICommonTreeParserParameter)new FloatDeclarationParser.Param(trace));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)11L, (long)result.getExponent());
        Assert.assertEquals((long)53L, (long)result.getMantissa());
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)result.getByteOrder());
        Assert.assertEquals((long)8L, (long)result.getAlignment());
    }
}

