/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views;

import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;

class LamiAxisCheckBoxOption {
    private final String fName;
    private final boolean fDefaultValue;
    private @Nullable Button fButton;
    private boolean fValue;
    private final Predicate<LamiTableEntryAspect> fAppliesToAspect;

    public LamiAxisCheckBoxOption(String name, boolean defaultValue, Predicate<LamiTableEntryAspect> validationPredicate) {
        this.fName = name;
        this.fDefaultValue = defaultValue;
        this.fValue = defaultValue;
        this.fButton = null;
        this.fAppliesToAspect = validationPredicate;
    }

    public String getName() {
        return this.fName;
    }

    public boolean getDefaultValue() {
        return this.fDefaultValue;
    }

    public void setButton(Button button) {
        this.fButton = button;
    }

    public boolean getValue() {
        return this.fValue;
    }

    public void updateValue() {
        if (this.fButton != null) {
            this.fValue = this.fButton.getSelection();
        }
    }

    public void setButtonEnabled(boolean enabled) {
        @Nullable Button button = this.fButton;
        if (button != null && button.getEnabled() != enabled) {
            button.setEnabled(enabled);
            button.setSelection(this.fDefaultValue);
        }
    }

    public boolean getButtonEnabled() {
        if (this.fButton != null) {
            return this.fButton.getEnabled();
        }
        return false;
    }

    public Predicate<LamiTableEntryAspect> getPredicate() {
        return this.fAppliesToAspect;
    }
}

