/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.core;

import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.preferences.SDViewPref;

public class Stop
extends GraphNode {
    public static final String STOP = "STOP";
    private Lifeline fLifeline = null;
    private int fEventOccurrence = 0;

    @Override
    public int getX() {
        if (this.fLifeline == null) {
            return 0;
        }
        return this.fLifeline.getX() + Metrics.getLifelineWidth() / 2 - 10;
    }

    @Override
    public int getY() {
        if (this.fLifeline == null) {
            return 0;
        }
        return this.fLifeline.getY() + this.fLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.fEventOccurrence - 10;
    }

    @Override
    public int getWidth() {
        if (this.fLifeline == null) {
            return 0;
        }
        return 20;
    }

    @Override
    public int getHeight() {
        if (this.fLifeline == null) {
            return 0;
        }
        return 20;
    }

    public void setLifeline(Lifeline theLifeline) {
        this.fLifeline = theLifeline;
    }

    public Lifeline getLifeline() {
        return this.fLifeline;
    }

    public int getEventOccurrence() {
        return this.fEventOccurrence;
    }

    public void setEventOccurrence(int occurrence) {
        this.fEventOccurrence = occurrence;
    }

    @Override
    public void draw(IGC context) {
        int lastWidth;
        SDViewPref pref = SDViewPref.getInstance();
        if (this.fLifeline.isSelected()) {
            context.setForeground(pref.getBackGroundColorSelection());
            context.setLineWidth(5);
            lastWidth = context.getLineWidth();
            context.setLineWidth(9);
            context.drawLine(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight());
            context.drawLine(this.getX() + this.getWidth(), this.getY(), this.getX(), this.getY() + this.getHeight());
            context.setLineWidth(lastWidth);
            context.setBackground(pref.getBackGroundColorSelection());
            context.setForeground(pref.getForeGroundColorSelection());
        } else {
            context.setBackground(pref.getBackGroundColor("PREF_LIFELINE"));
            context.setForeground(pref.getForeGroundColor("PREF_LIFELINE"));
        }
        lastWidth = context.getLineWidth();
        context.setLineWidth(3);
        context.drawLine(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight());
        context.drawLine(this.getX() + this.getWidth(), this.getY(), this.getX(), this.getY() + this.getHeight());
        context.setLineWidth(lastWidth);
    }

    @Override
    public String getArrayId() {
        return STOP;
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }
}

