/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.core.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandOutputListener;

@NonNullByDefault
class InputReader {
    private static final int JOIN_TIMEOUT = 300;
    private static final int BYTES_PER_KB = 1024;
    private final InputStreamReader fReader;
    private final Thread fThread;
    private final StringBuilder fResult = new StringBuilder();
    private volatile boolean fDone;

    public InputReader(InputStream inputStream, final @Nullable ICommandOutputListener listener, final boolean isStdOut) {
        this.fReader = new InputStreamReader(inputStream);
        this.fThread = new Thread(){

            @Override
            public void run() {
                char[] buffer = new char[1024];
                try {
                    int read;
                    while (!InputReader.this.fDone && (read = InputReader.this.fReader.read(buffer)) > 0) {
                        InputReader.this.fResult.append(buffer, 0, read);
                        if (listener == null) continue;
                        if (isStdOut) {
                            listener.outputUpdated(String.valueOf(buffer, 0, read));
                            continue;
                        }
                        listener.errorOutputUpdated(String.valueOf(buffer, 0, read));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.fThread.start();
    }

    public void waitFor(IProgressMonitor monitor) throws InterruptedException {
        while (this.fThread.isAlive() && !monitor.isCanceled()) {
            this.fThread.join(300L);
        }
    }

    public void stop() {
        this.fDone = true;
        this.fThread.interrupt();
    }

    public String toString() {
        return NonNullUtils.nullToEmptyString((Object)this.fResult.toString());
    }
}

