/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.model.config;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;
import org.eclipse.tracecompass.tmf.core.config.TmfConfiguration;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfConfigurationException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TmfConfigurationTest {
    private static final String PATH = "/tmp/my-test.xml";
    private static final String ID = "my-test.xml";
    private static final String DESC = "descriptor";
    private static final String SOURCE_ID = "my-source-id";
    private static final @NonNull Map<@NonNull String, @NonNull Object> PARAM = ImmutableMap.of((Object)"path", (Object)"/tmp/home/my-test.xml");
    private static final String EXPECTED_TO_STRING = "TmfConfiguration[fName=/tmp/my-test.xml, fDescription=descriptor, fType=my-source-id, fId=my-test.xml, fParameters={path=/tmp/home/my-test.xml}]";
    private static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();

    @BeforeClass
    public static void setUp() throws IOException {
        TEMPORARY_FOLDER.create();
    }

    @AfterClass
    public static void cleanUp() {
        TEMPORARY_FOLDER.delete();
    }

    @Test
    public void testBuilder() {
        TmfConfiguration.Builder builder = new TmfConfiguration.Builder().setName(PATH).setId(ID).setDescription(DESC).setSourceTypeId(SOURCE_ID).setParameters(PARAM);
        ITmfConfiguration config = builder.build();
        Assert.assertEquals((Object)PATH, (Object)config.getName());
        Assert.assertEquals((Object)ID, (Object)config.getId());
        Assert.assertEquals((Object)DESC, (Object)config.getDescription());
        Assert.assertEquals((Object)SOURCE_ID, (Object)config.getSourceTypeId());
        Assert.assertEquals(PARAM, (Object)config.getParameters());
    }

    @Test
    public void testBuilderMissingParams() {
        TmfConfiguration.Builder builder = new TmfConfiguration.Builder().setName(PATH).setDescription(DESC).setSourceTypeId(SOURCE_ID).setParameters(PARAM);
        ITmfConfiguration config = builder.build();
        Assert.assertEquals((Object)UUID.nameUUIDFromBytes(Objects.requireNonNull(PATH.getBytes(Charset.defaultCharset()))).toString(), (Object)config.getId());
        builder = new TmfConfiguration.Builder().setName(PATH).setSourceTypeId(SOURCE_ID).setId("\n").setDescription(DESC).setParameters(PARAM);
        config = builder.build();
        Assert.assertEquals((Object)UUID.nameUUIDFromBytes(Objects.requireNonNull(PATH.getBytes(Charset.defaultCharset()))).toString(), (Object)config.getId());
        builder = new TmfConfiguration.Builder().setId(ID).setSourceTypeId(SOURCE_ID);
        builder.build();
    }

    @Test
    public void testEquality() {
        TmfConfiguration.Builder builder = new TmfConfiguration.Builder().setName(PATH).setId(ID).setDescription(DESC).setSourceTypeId(SOURCE_ID).setParameters(PARAM);
        ITmfConfiguration baseConfiguration = builder.build();
        ITmfConfiguration testConfig = builder.build();
        Assert.assertEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertEquals((Object)testConfig, (Object)baseConfiguration);
        builder.setName("Other path");
        testConfig = builder.build();
        Assert.assertNotEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertNotEquals((Object)testConfig, (Object)baseConfiguration);
        builder.setName(PATH);
        builder.setId("Other Id");
        testConfig = builder.build();
        Assert.assertNotEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertNotEquals((Object)testConfig, (Object)baseConfiguration);
        builder.setId(ID);
        builder.setDescription("Other desc");
        testConfig = builder.build();
        Assert.assertNotEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertNotEquals((Object)testConfig, (Object)baseConfiguration);
        builder.setDescription(DESC);
        builder.setSourceTypeId("Other type id");
        testConfig = builder.build();
        Assert.assertNotEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertNotEquals((Object)testConfig, (Object)baseConfiguration);
        builder.setSourceTypeId(SOURCE_ID);
        builder.setParameters((Map)ImmutableMap.of((Object)"path", (Object)"/tmp/home/my-other.xml"));
        testConfig = builder.build();
        Assert.assertNotEquals((Object)baseConfiguration, (Object)testConfig);
        Assert.assertNotEquals((Object)testConfig, (Object)baseConfiguration);
    }

    @Test
    public void testToString() {
        TmfConfiguration.Builder builder = new TmfConfiguration.Builder().setName(PATH).setId(ID).setDescription(DESC).setSourceTypeId(SOURCE_ID).setParameters(PARAM);
        Assert.assertEquals((Object)EXPECTED_TO_STRING, (Object)builder.build().toString());
    }

    @Test
    public void testHashCode() {
        TmfConfiguration.Builder builder = new TmfConfiguration.Builder().setName(PATH).setId(ID).setDescription(DESC).setSourceTypeId(SOURCE_ID).setParameters(PARAM);
        ITmfConfiguration config1 = builder.build();
        builder = new TmfConfiguration.Builder().setName("/tmp/my-test.xml1").setId("my-test.xml1").setDescription("descriptor1").setSourceTypeId("my-source-id1").setParameters((Map)ImmutableMap.of((Object)"path", (Object)"/tmp/home/my-other.xml"));
        ITmfConfiguration config2 = builder.build();
        Assert.assertEquals((long)config1.hashCode(), (long)config1.hashCode());
        Assert.assertEquals((long)config2.hashCode(), (long)config2.hashCode());
        Assert.assertNotEquals((long)config1.hashCode(), (long)config2.hashCode());
    }

    @Test
    public void testJsonFile() throws TmfConfigurationException {
        TmfConfiguration.Builder builder = new TmfConfiguration.Builder().setName(PATH).setId(ID).setDescription(DESC).setSourceTypeId(SOURCE_ID).setParameters(PARAM);
        ITmfConfiguration config1 = builder.build();
        File folder = TEMPORARY_FOLDER.getRoot();
        Path rootFolder = new Path(folder.getAbsolutePath());
        TmfConfiguration.writeConfiguration((ITmfConfiguration)config1, (IPath)rootFolder);
        IPath path = rootFolder.append(config1.getId()).addFileExtension("json");
        File file = path.toFile();
        Assert.assertTrue((boolean)file.exists());
        ITmfConfiguration readConfig = TmfConfiguration.fromJsonFile((File)file);
        Assert.assertNotNull((Object)readConfig);
        Assert.assertEquals((Object)config1, (Object)readConfig);
    }
}

