/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.analysis;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleSource;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.AnalysisModuleSourceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.AnalysisModuleTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnalysisManagerTest {
    public static final @NonNull String MODULE_PARAM = "org.eclipse.linuxtools.tmf.core.tests.analysis.test";
    public static final @NonNull String MODULE_PARAM_DEFAULT = "org.eclipse.linuxtools.tmf.core.tests.analysis.test2";
    public static final @NonNull String MODULE_SECOND = "org.eclipse.linuxtools.tmf.core.tests.analysis.testother";
    public static final @NonNull String MODULE_REQ = "org.eclipse.linuxtools.tmf.core.tests.analysis.reqtest";
    private ITmfTrace fTrace;

    @Before
    public void setupTraces() {
        this.fTrace = TmfTestTrace.A_TEST_10K2.getTraceAsStub2();
    }

    @After
    public void cleanupTraces() {
        TmfTestTrace.A_TEST_10K.dispose();
        this.fTrace.dispose();
    }

    @Test
    public void testGetAnalysisModules() {
        Multimap modules = TmfAnalysisManager.getAnalysisModules();
        Assert.assertTrue((modules.size() >= 3 ? 1 : 0) != 0);
        Collection moduleList = modules.get((Object)MODULE_PARAM_DEFAULT);
        Assert.assertEquals((long)1L, (long)moduleList.size());
        IAnalysisModuleHelper module = (IAnalysisModuleHelper)moduleList.iterator().next();
        Assert.assertTrue((boolean)module.isAutomatic());
        moduleList = modules.get((Object)MODULE_PARAM);
        Assert.assertEquals((long)1L, (long)moduleList.size());
        module = (IAnalysisModuleHelper)moduleList.iterator().next();
        Assert.assertFalse((boolean)module.isAutomatic());
    }

    @Test
    public void testListForTraces() {
        ITmfTrace trace = TmfTestTrace.A_TEST_10K.getTrace();
        Class<@NonNull ?> traceClass = trace.getClass();
        Assert.assertNotNull(traceClass);
        Map map = TmfAnalysisManager.getAnalysisModules(traceClass);
        Assert.assertTrue((boolean)map.containsKey(MODULE_PARAM));
        Assert.assertTrue((boolean)map.containsKey(MODULE_PARAM_DEFAULT));
        Assert.assertFalse((boolean)map.containsKey(MODULE_SECOND));
        traceClass = this.fTrace.getClass();
        Assert.assertNotNull(traceClass);
        map = TmfAnalysisManager.getAnalysisModules(traceClass);
        Assert.assertTrue((boolean)map.containsKey(MODULE_PARAM));
        Assert.assertTrue((boolean)map.containsKey(MODULE_PARAM_DEFAULT));
        Assert.assertTrue((boolean)map.containsKey(MODULE_SECOND));
    }

    @Test
    public void testSources() {
        ITmfTrace trace = TmfTestTrace.A_TEST_10K.getTrace();
        Class<@NonNull ?> traceClass = trace.getClass();
        Assert.assertNotNull(traceClass);
        Map map = TmfAnalysisManager.getAnalysisModules(traceClass);
        Assert.assertFalse((boolean)map.containsKey(AnalysisModuleTestHelper.moduleStubEnum.TEST.name()));
        Class<@NonNull ?> ftraceClass = this.fTrace.getClass();
        Assert.assertNotNull(ftraceClass);
        map = TmfAnalysisManager.getAnalysisModules(ftraceClass);
        Assert.assertFalse((boolean)map.containsKey(AnalysisModuleTestHelper.moduleStubEnum.TEST2.name()));
        AnalysisModuleSourceStub stub = new AnalysisModuleSourceStub();
        TmfAnalysisManager.registerModuleSource((IAnalysisModuleSource)stub);
        try {
            map = TmfAnalysisManager.getAnalysisModules(traceClass);
            Assert.assertTrue((boolean)map.containsKey(AnalysisModuleTestHelper.moduleStubEnum.TEST.name()));
            map = TmfAnalysisManager.getAnalysisModules(ftraceClass);
            Assert.assertTrue((boolean)map.containsKey(AnalysisModuleTestHelper.moduleStubEnum.TEST2.name()));
        }
        finally {
            TmfAnalysisManager.deregisterModuleSource((IAnalysisModuleSource)stub);
            trace.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testRefreshModules() {
        ITmfTrace trace = TmfTestTrace.A_TEST_10K.getTrace();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal((Object)this, trace, null));
        @NonNull @NonNull Iterable modules = trace.getAnalysisModules();
        Assert.assertFalse((boolean)StreamSupport.stream(modules.spliterator(), false).anyMatch(module -> module.getId().equals(AnalysisModuleTestHelper.moduleStubEnum.TEST.name())));
        AnalysisModuleSourceStub stub = new AnalysisModuleSourceStub();
        TmfAnalysisManager.registerModuleSource((IAnalysisModuleSource)stub);
        try {
            modules = trace.getAnalysisModules();
            Assert.assertFalse((boolean)StreamSupport.stream(modules.spliterator(), false).anyMatch(module -> module.getId().equals(AnalysisModuleTestHelper.moduleStubEnum.TEST.name())));
            long before = StreamSupport.stream(modules.spliterator(), false).count();
            IStatus status = trace.refreshAnalysisModules();
            Assert.assertTrue((boolean)status.isOK());
            modules = trace.getAnalysisModules();
            long after = StreamSupport.stream(modules.spliterator(), false).count();
            Assert.assertTrue((after == before + 1L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)StreamSupport.stream(modules.spliterator(), false).anyMatch(module -> module.getId().equals(AnalysisModuleTestHelper.moduleStubEnum.TEST.name())));
            before = after;
            TmfAnalysisManager.deregisterModuleSource((IAnalysisModuleSource)stub);
            status = trace.refreshAnalysisModules();
            Assert.assertTrue((boolean)status.isOK());
            modules = trace.getAnalysisModules();
            after = StreamSupport.stream(modules.spliterator(), false).count();
            Assert.assertTrue((after == before - 1L ? 1 : 0) != 0);
            Assert.assertFalse((boolean)StreamSupport.stream(modules.spliterator(), false).anyMatch(module -> module.getId().equals(AnalysisModuleTestHelper.moduleStubEnum.TEST.name())));
        }
        finally {
            TmfAnalysisManager.deregisterModuleSource((IAnalysisModuleSource)stub);
            trace.dispose();
        }
    }
}

