/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.cli.core.parser.help.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.CliCommandLine;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.CliParserException;
import org.eclipse.tracecompass.internal.provisional.tmf.cli.core.parser.CliParserManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HelpCliParserTest {
    public static final String HELP_PLACEHOLDER = "%HELP%";
    private static final String TESTFILES = "testfiles/";
    private static final String HELP_FILE = "helpText.txt";
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final PrintStream originalOut = System.out;
    private final String fCmdLine;
    private final boolean fException;
    private final @Nullable String fTextFile;

    @Before
    public void setUpStreams() {
        System.setOut(new PrintStream(this.outContent));
    }

    @After
    public void restoreStreams() {
        System.setOut(this.originalOut);
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({"--cli --help", false, HELP_FILE}, {"--cli -h", false, HELP_FILE}, {"--cli -faulty", true, "wrongOption.txt"});
    }

    public HelpCliParserTest(String cmdLine, boolean exception, @Nullable String fileText) {
        this.fCmdLine = cmdLine;
        this.fException = exception;
        this.fTextFile = fileText;
    }

    @Test
    public void testCmdLineArguments() throws IOException {
        byte[] outputBytes = this.fTextFile != null ? Files.readAllBytes(Paths.get(TESTFILES + this.fTextFile, new String[0])) : new byte[]{};
        String outputString = this.replaceHelp(new String(outputBytes));
        CliParserException exception = null;
        try {
            String[] args = this.fCmdLine.split(" ");
            CliCommandLine parsedCli = CliParserManager.getInstance().parse(args);
            Assert.assertNotNull((Object)parsedCli);
            CliParserManager.applicationStartup((CliCommandLine)parsedCli);
        }
        catch (CliParserException e) {
            exception = e;
        }
        Assert.assertEquals((String)("Exception " + String.valueOf((Object)exception)), (Object)this.fException, (Object)(exception != null ? 1 : 0));
        Assert.assertEquals((Object)outputString, (Object)this.outContent.toString());
    }

    private String replaceHelp(String outputString) throws IOException {
        if (outputString.contains(HELP_PLACEHOLDER)) {
            String helpString = this.getHelpText();
            return outputString.replace(HELP_PLACEHOLDER, helpString);
        }
        return outputString;
    }

    protected String getHelpText() throws IOException {
        byte[] helpBytes = Files.readAllBytes(Paths.get("testfiles/helpText.txt", new String[0]));
        return new String(helpBytes);
    }
}

