/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.chart.core.tests.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.AbstractDoubleResolver;
import org.eclipse.tracecompass.tmf.chart.core.tests.stubs.StubObject;
import org.junit.Assert;
import org.junit.Test;

public class DoubleResolverTest {
    private static final AbstractDoubleResolver<StubObject> DOUBLE_RESOLVER = new AbstractDoubleResolver<StubObject>(){

        public @NonNull Function<StubObject, @Nullable Double> getMapper() {
            return o -> o.getDbl();
        }
    };

    @Test
    public void testLimitValues() {
        Assert.assertEquals((double)Double.MIN_VALUE, (double)DOUBLE_RESOLVER.getMinValue(), (double)1.0E-6);
        Assert.assertEquals((double)Double.MAX_VALUE, (double)DOUBLE_RESOLVER.getMaxValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)DOUBLE_RESOLVER.getZeroValue(), (double)1.0E-6);
    }

    @Test
    public void testComparator() {
        ArrayList<@NonNull Double> list = new ArrayList<Double>();
        list.add(0.0);
        list.add(1234.1234);
        list.add(-3.45);
        Collections.sort(list, DOUBLE_RESOLVER.getComparator());
        Assert.assertEquals((double)-3.45, (double)((Double)list.get(0)), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)((Double)list.get(1)), (double)1.0E-6);
        Assert.assertEquals((double)1234.1234, (double)((Double)list.get(2)), (double)1.0E-6);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testMapper() {
        @Nullable Function mapper = DOUBLE_RESOLVER.getMapper();
        StubObject obj = new StubObject("str", 1, 0L, -3.45);
        Double dbl = (Double)mapper.apply(obj);
        Assert.assertNotNull((Object)dbl);
        Assert.assertEquals((double)-3.45, (double)dbl, (double)1.0E-6);
        obj = new StubObject("str", 1, 0L, 0.0);
        dbl = (Double)mapper.apply(obj);
        Assert.assertNotNull((Object)dbl);
        Assert.assertEquals((double)0.0, (double)dbl, (double)1.0E-6);
        obj = new StubObject("str", 1, 1234L, 1234.1234);
        dbl = (Double)mapper.apply(obj);
        Assert.assertNotNull((Object)dbl);
        Assert.assertEquals((double)1234.1234, (double)dbl, (double)1.0E-6);
    }
}

