/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider;

import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.PatternAnalysisTestUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class TmfXmlSegmentTimestampDescriptionTest {
    private static final @NonNull String testTrace2 = "test_traces/testTrace2.xml";
    private static final long nbEvents = 4L;
    private static ITmfTrace fTrace;
    private static XmlPatternAnalysis fModule;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testTimestampDescription() throws TmfAnalysisException {
        fTrace = XmlUtilsTest.initializeTrace(testTrace2);
        Assert.assertNotNull((Object)fTrace);
        fModule = PatternAnalysisTestUtils.initModule(TmfXmlTestFiles.VALID_SEGMENT_TIMESTAMP_DESCRIPTION);
        fModule.setTrace(Objects.requireNonNull(fTrace));
        fModule.schedule();
        fModule.waitForCompletion();
        @NonNull ISegmentStore ss = fModule.getSegmentStore();
        Assert.assertNotNull((Object)ss);
        Assert.assertEquals((String)"The number of segment should be equal to the number of events", (long)4L, (long)ss.size());
        @NonNull Iterator iterator = ss.iterator();
        ISegment firstSegment = (ISegment)iterator.next();
        Assert.assertEquals((String)"wrong segment duration", (long)9L, (long)firstSegment.getLength());
    }

    @AfterClass
    public static void tearDown() {
        if (fTrace != null) {
            fTrace.dispose();
        }
        if (fModule != null) {
            fModule.dispose();
        }
    }
}

