/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core.tests.interfaces;

import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentStoreFactory;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.SegmentAspects;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.SegmentTypeComparators;
import org.junit.Assert;
import org.junit.Test;

@NonNullByDefault
public class INamedSegmentTest {
    private static final BasicSegment BASE_SEGMENT = new BasicSegment(10L, 12L);
    private static final NamedSegment NAMED_SEGMENT1 = new NamedSegment(10L, 12L, "test");
    private static final NamedSegment NAMED_SEGMENT2 = new NamedSegment(12L, 13L, "abc");
    private static final NamedSegment NAMED_SEGMENT3 = new NamedSegment(14L, 15L, "abc");
    private static final NamedSegment NAMED_SEGMENT4 = new NamedSegment(14L, 15L, "");

    @Test
    public void testComparator() {
        BasicSegment current;
        Comparator cmp = SegmentTypeComparators.NAMED_SEGMENT_COMPARATOR;
        Assert.assertEquals((long)cmp.compare(NAMED_SEGMENT2, NAMED_SEGMENT3), (long)cmp.compare(NAMED_SEGMENT3, NAMED_SEGMENT2));
        Assert.assertTrue((cmp.compare(NAMED_SEGMENT1, NAMED_SEGMENT2) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)cmp.compare(NAMED_SEGMENT1, NAMED_SEGMENT2), (long)(-1 * cmp.compare(NAMED_SEGMENT2, NAMED_SEGMENT1)));
        Assert.assertTrue((cmp.compare(BASE_SEGMENT, NAMED_SEGMENT2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((cmp.compare(NAMED_SEGMENT2, BASE_SEGMENT) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((cmp.compare(BASE_SEGMENT, NAMED_SEGMENT4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((cmp.compare(NAMED_SEGMENT4, BASE_SEGMENT) < 0 ? 1 : 0) != 0);
        ISegmentStore segStore = SegmentStoreFactory.createSegmentStore((SegmentStoreFactory.SegmentStoreType[])new SegmentStoreFactory.SegmentStoreType[]{SegmentStoreFactory.SegmentStoreType.Fast});
        segStore.add((Object)BASE_SEGMENT);
        segStore.add((Object)NAMED_SEGMENT1);
        segStore.add((Object)NAMED_SEGMENT2);
        segStore.add((Object)NAMED_SEGMENT3);
        segStore.add((Object)NAMED_SEGMENT4);
        Iterable iterable = segStore.iterator(cmp);
        Iterator iterator = iterable.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        BasicSegment prev = current = (BasicSegment)iterator.next();
        int count = 1;
        while (iterator.hasNext()) {
            current = (BasicSegment)iterator.next();
            Assert.assertTrue((cmp.compare(prev, current) <= 0 ? 1 : 0) != 0);
            prev = current;
            ++count;
        }
        Assert.assertEquals((long)5L, (long)count);
        iterable = segStore.iterator((Comparator)NonNullUtils.checkNotNull(cmp.reversed()));
        iterator = iterable.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        prev = current = (BasicSegment)iterator.next();
        count = 1;
        while (iterator.hasNext()) {
            current = (BasicSegment)iterator.next();
            Assert.assertTrue((cmp.compare(prev, current) >= 0 ? 1 : 0) != 0);
            prev = current;
            ++count;
        }
        Assert.assertEquals((long)5L, (long)count);
    }

    @Test
    public void testNamedAspect() {
        Assert.assertNull((Object)SegmentAspects.getName((ISegment)BASE_SEGMENT));
        Assert.assertEquals((Object)"test", (Object)SegmentAspects.getName((ISegment)NAMED_SEGMENT1));
        Assert.assertEquals((Object)"abc", (Object)SegmentAspects.getName((ISegment)NAMED_SEGMENT2));
        Assert.assertEquals((Object)"", (Object)SegmentAspects.getName((ISegment)NAMED_SEGMENT4));
    }

    private static class NamedSegment
    extends BasicSegment
    implements INamedSegment {
        private static final long serialVersionUID = -7955666081972046597L;
        private final String fName;

        public NamedSegment(long start, long end, String name) {
            super(start, end);
            this.fName = name;
        }

        public @NonNull String getName() {
            return this.fName;
        }
    }
}

