/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.condition;

import org.eclipse.tracecompass.internal.datastore.core.condition.SingletonTimeRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.junit.Assert;
import org.junit.Test;

public class SingletonTimeRangeConditionTest {
    private static final long VALUE = 5L;
    private static final SingletonTimeRangeCondition CONDITION = new SingletonTimeRangeCondition(5L);

    @Test
    public void testBounds() {
        Assert.assertEquals((long)5L, (long)((int)CONDITION.min()));
        Assert.assertEquals((long)5L, (long)((int)CONDITION.max()));
    }

    @Test
    public void testPredicate() {
        Assert.assertFalse((boolean)CONDITION.test(-5L));
        Assert.assertTrue((boolean)CONDITION.test(5L));
        Assert.assertFalse((boolean)CONDITION.test(15L));
    }

    @Test
    public void testIntersects() {
        Assert.assertFalse((boolean)CONDITION.intersects(Integer.MIN_VALUE, 4L));
        Assert.assertTrue((boolean)CONDITION.intersects(4L, 6L));
        Assert.assertTrue((boolean)CONDITION.intersects(5L, 6L));
        Assert.assertTrue((boolean)CONDITION.intersects(4L, 5L));
        Assert.assertFalse((boolean)CONDITION.intersects(6L, Integer.MAX_VALUE));
    }

    @Test
    public void testSubCondition() {
        TimeRangeCondition sub = CONDITION.subCondition(4L, 6L);
        Assert.assertNotNull((Object)sub);
        Assert.assertEquals((Object)sub, (Object)CONDITION);
        sub = CONDITION.subCondition(Long.MIN_VALUE, 4L);
        Assert.assertNull((Object)sub);
        sub = CONDITION.subCondition(6L, 7L);
        Assert.assertNull((Object)sub);
    }
}

