/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.dynamicarray;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.types.SequenceDeclaration;

public final class DynamicLengthArrayParser
extends AbstractScopedCommonTreeParser {
    public static final DynamicLengthArrayParser INSTANCE = new DynamicLengthArrayParser();

    private DynamicLengthArrayParser() {
    }

    @Override
    public IDeclaration parse(ICTFMetadataNode node, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(node instanceof JsonStructureFieldMemberMetadataNode)) {
            throw new ParseException("Dynamic-length array only supported in JSON metadata");
        }
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        JsonStructureFieldMemberMetadataNode member = (JsonStructureFieldMemberMetadataNode)node;
        JsonElement fieldClassElement = member.getFieldClass();
        if (fieldClassElement == null || !fieldClassElement.isJsonObject()) {
            throw new ParseException(this.getClass().getName() + " fieldclass must be a json object.");
        }
        JsonObject fieldClass = member.getFieldClass().getAsJsonObject();
        JsonElement lengthFieldLocation = fieldClass.get("length-field-location");
        if (lengthFieldLocation == null) {
            throw new ParseException("Dynamic-length array requires length-field-location property");
        }
        JsonElement elementFieldClass = fieldClass.get("element-field-class");
        if (elementFieldClass == null) {
            throw new ParseException("Dynamic-length array requires element-field-class property");
        }
        JsonElement pathElement = lengthFieldLocation.getAsJsonObject().get("path");
        String lengthName = pathElement.isJsonArray() ? pathElement.getAsJsonArray().get(pathElement.getAsJsonArray().size() - 1).getAsString() : pathElement.getAsString();
        CTFTrace trace = ((Param)param).getTrace();
        DeclarationScope scope = ((Param)param).getScope();
        JsonStructureFieldMemberMetadataNode elementNode = new JsonStructureFieldMemberMetadataNode(node, "", "", "", elementFieldClass.getAsJsonObject());
        IDeclaration elementDeclaration = TypeAliasParser.INSTANCE.parse(elementNode, new TypeAliasParser.Param(trace, scope));
        return new SequenceDeclaration(lengthName, elementDeclaration);
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final CTFTrace fTrace;
        private final DeclarationScope fScope;

        public Param(CTFTrace trace, DeclarationScope scope) {
            this.fTrace = trace;
            this.fScope = scope;
        }

        public CTFTrace getTrace() {
            return this.fTrace;
        }

        public DeclarationScope getScope() {
            return this.fScope;
        }
    }
}

