/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.format;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public class DecimalWithUnitPrefixFormat
extends Format {
    private static final long serialVersionUID = 3934127385682676804L;
    private static final String METRIC_K = "k";
    private static final String BINARY_K = "K";
    private static final String M = "M";
    private static final String G = "G";
    private static final String T = "T";
    private static final String MILLI = "m";
    private static final String MICRO = "\u00b5";
    private static final String MICRO2 = "u";
    private static final String NANO = "n";
    private static final String PICO = "p";
    private static final String SUFFIX_REPLACEMENT = "%suffix%";
    private static final long KILO = 1000L;
    private static final Format FORMAT = new DecimalFormat("#.###");
    private static final String UNIT_PATTERN_STR = "^[\\s]*([kKMGTm\u00b5unp]?)%suffix%";
    private static final String SUFFIX = "";
    private static final Map<String, Integer> PREFIX_MAP = ImmutableMap.builder().put((Object)"k", (Object)1).put((Object)"K", (Object)1).put((Object)"M", (Object)2).put((Object)"G", (Object)3).put((Object)"T", (Object)4).put((Object)"m", (Object)-1).put((Object)"\u00b5", (Object)-2).put((Object)"u", (Object)-2).put((Object)"n", (Object)-3).put((Object)"p", (Object)-4).build();
    private final String fSuffix;
    private final Pattern fUnitPattern;
    private final long fKilo;
    private final String fKiloPrefix;

    protected DecimalWithUnitPrefixFormat() {
        this(SUFFIX, 1000L);
    }

    protected DecimalWithUnitPrefixFormat(String suffix, long kiloValue) {
        this.fSuffix = suffix;
        this.fKilo = kiloValue;
        this.fUnitPattern = Pattern.compile(UNIT_PATTERN_STR.replace(SUFFIX_REPLACEMENT, suffix));
        this.fKiloPrefix = this.fKilo == 1024L ? BINARY_K : METRIC_K;
    }

    public DecimalWithUnitPrefixFormat(@NonNull String suffix) {
        this(suffix, 1000L);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Number) {
            Number num = (Number)obj;
            double value = num.doubleValue();
            double abs = Math.abs(value);
            if (value == 0.0) {
                return toAppendTo.append("0").append(' ').append(this.fSuffix);
            }
            if (abs >= 1.0) {
                if (abs >= (double)(this.fKilo * this.fKilo * this.fKilo * this.fKilo)) {
                    return toAppendTo.append(FORMAT.format(value / (double)(this.fKilo * this.fKilo * this.fKilo * this.fKilo))).append(' ').append(T).append(this.fSuffix);
                }
                if (abs >= (double)(this.fKilo * this.fKilo * this.fKilo)) {
                    return toAppendTo.append(FORMAT.format(value / (double)(this.fKilo * this.fKilo * this.fKilo))).append(' ').append(G).append(this.fSuffix);
                }
                if (abs >= (double)(this.fKilo * this.fKilo)) {
                    return toAppendTo.append(FORMAT.format(value / (double)(this.fKilo * this.fKilo))).append(' ').append(M).append(this.fSuffix);
                }
                if (abs >= (double)this.fKilo) {
                    return toAppendTo.append(FORMAT.format(value / (double)this.fKilo)).append(' ').append(this.fKiloPrefix).append(this.fSuffix);
                }
                return toAppendTo.append(FORMAT.format(value)).append(' ').append(this.fSuffix);
            }
            if (abs < 1.0 / (double)(this.fKilo * this.fKilo * this.fKilo)) {
                return toAppendTo.append(FORMAT.format(value * (double)this.fKilo * (double)this.fKilo * (double)this.fKilo * (double)this.fKilo)).append(' ').append(PICO).append(this.fSuffix);
            }
            if (abs < 1.0 / (double)(this.fKilo * this.fKilo)) {
                return toAppendTo.append(FORMAT.format(value * (double)this.fKilo * (double)this.fKilo * (double)this.fKilo)).append(' ').append(NANO).append(this.fSuffix);
            }
            if (abs < 1.0 / (double)this.fKilo) {
                return toAppendTo.append(FORMAT.format(value * (double)this.fKilo * (double)this.fKilo)).append(' ').append(MICRO).append(this.fSuffix);
            }
            return toAppendTo.append(FORMAT.format(value * 1000.0)).append(' ').append(MILLI).append(this.fSuffix);
        }
        return toAppendTo;
    }

    @Override
    public Number parseObject(String source, ParsePosition pos) {
        Number number = NumberFormat.getInstance().parse(source, pos);
        if (number == null) {
            return null;
        }
        String remaining = source.substring(pos.getIndex());
        Matcher matcher = this.fUnitPattern.matcher(remaining);
        Integer thousands = null;
        if (matcher.find()) {
            String unitString = matcher.group();
            String prefix = matcher.group(1);
            thousands = PREFIX_MAP.get(prefix);
            pos.setIndex(pos.getIndex() + unitString.length());
        }
        if (thousands != null && thousands < 0 && Double.isFinite(number.doubleValue())) {
            double multiplier = 1.0 / Math.pow(this.fKilo, Math.abs(thousands));
            BigDecimal bd = new BigDecimal(number.toString());
            bd = bd.multiply(BigDecimal.valueOf(multiplier));
            return bd.doubleValue();
        }
        if (thousands != null && Double.isFinite(number.doubleValue())) {
            long multiplier = (long)Math.pow(this.fKilo, thousands.intValue());
            BigDecimal bd = new BigDecimal(number.toString());
            if ((bd = bd.multiply(BigDecimal.valueOf(multiplier))).remainder(BigDecimal.ONE).equals(BigDecimal.ZERO) && bd.abs().compareTo(new BigDecimal(Long.MAX_VALUE)) < 0) {
                return bd.longValue();
            }
            return bd.doubleValue();
        }
        return number;
    }
}

