/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.counters.ui.swtbot.tests;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.perf.views.ViewsResponseTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class CountersViewBenchmark
extends ViewsResponseTest {
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";

    protected void beforeRunningTest(ITmfTrace trace) {
        IAnalysisModule analysis = trace.getAnalysisModule("org.eclipse.tracecompass.analysis.counters.core.counteranalysis");
        Assert.assertNotNull((String)("CounterAnalysis cannot run on trace " + trace.getName()), (Object)analysis);
        analysis.schedule();
        analysis.waitForCompletion();
    }

    protected void prepareWorkspace() {
        SWTBotUtils.switchToPerspective((String)"org.eclipse.linuxtools.tmf.ui.perspective");
    }

    @Test
    public void testKernelVM() throws IOException {
        this.runTestWithTrace(FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.KERNEL_VM.getTraceURL())).getAbsolutePath(), TRACE_TYPE, Collections.singleton("org.eclipse.tracecompass.analysis.counters.ui.views.countersview"));
    }

    public void prepareView(SWTBotView view) {
        SWTBotTree tree = view.bot().tree();
        SWTBotTreeItem[] sWTBotTreeItemArray = tree.getAllItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem item = sWTBotTreeItemArray[n2];
            item.check();
            ++n2;
        }
    }
}

