/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.build;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager2;
import org.eclipse.cdt.core.build.ICBuildConfigurationProvider;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.core.build.Messages;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CBuildConfigurationManager
implements ICBuildConfigurationManager,
ICBuildConfigurationManager2,
IResourceChangeListener {
    private Map<String, Provider> providers;
    private Map<IBuildConfiguration, ICBuildConfiguration> configs = new HashMap<IBuildConfiguration, ICBuildConfiguration>();
    private Set<IBuildConfiguration> noConfigs = new HashSet<IBuildConfiguration>();

    public void reset() {
        this.configs = new HashMap<IBuildConfiguration, ICBuildConfiguration>();
        this.noConfigs = new HashSet<IBuildConfiguration>();
    }

    public CBuildConfigurationManager() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    private synchronized void initProviders() {
        if (this.providers == null) {
            this.providers = new HashMap<String, Provider>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "buildConfigProvider");
            IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                Provider provider = new Provider(element);
                this.providers.put(provider.getId(), provider);
                ++n2;
            }
        }
    }

    private Provider getProviderDelegate(String id) {
        return this.providers.get(id);
    }

    @Override
    public ICBuildConfigurationProvider getProvider(String id) {
        this.initProviders();
        Provider provider = this.providers.get(id);
        return provider != null ? provider.getProvider() : null;
    }

    public ICBuildConfigurationProvider getProvider(String id, IProject project) {
        this.initProviders();
        Provider provider = this.getProviderDelegate(id);
        if (provider != null && provider.supports(project)) {
            return provider.getProvider();
        }
        return null;
    }

    public ICBuildConfigurationProvider getProvider(IProject project) {
        this.initProviders();
        for (Provider provider : this.providers.values()) {
            if (!provider.supports(project)) continue;
            return provider.getProvider();
        }
        return null;
    }

    @Override
    public boolean hasConfiguration(ICBuildConfigurationProvider provider, IProject project, String configName) throws CoreException {
        String name = provider.getId() + "/" + configName;
        return project.hasBuildConfig(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBuildConfiguration createBuildConfiguration(ICBuildConfigurationProvider provider, IProject project, String configName, IProgressMonitor monitor) throws CoreException {
        CoreModel m;
        String name = provider.getId() + "/" + configName;
        CoreModel coreModel = m = CoreModel.getDefault();
        synchronized (coreModel) {
            HashSet<Object> names = new HashSet<Object>();
            IBuildConfiguration[] iBuildConfigurationArray = project.getBuildConfigs();
            int n = iBuildConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildConfiguration config = iBuildConfigurationArray[n2];
                names.add(config.getName());
                ++n2;
            }
            names.add("");
            IProjectDescription desc = project.getDescription();
            names.add(name);
            desc.setBuildConfigs(names.toArray(new String[names.size()]));
            project.setDescription(desc, monitor);
        }
        return project.getBuildConfig(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBuildConfiguration(IBuildConfiguration buildConfig, ICBuildConfiguration cConfig) {
        Map<IBuildConfiguration, ICBuildConfiguration> map = this.configs;
        synchronized (map) {
            this.configs.put(buildConfig, cConfig);
        }
        CModelManager.getDefault().resetBinaryParser(buildConfig.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recheckConfigs() {
        this.initProviders();
        ICBuildConfiguration config = null;
        HashSet<IProject> projects = new HashSet<IProject>();
        Map<IBuildConfiguration, ICBuildConfiguration> map = this.configs;
        synchronized (map) {
            Iterator<IBuildConfiguration> iterator = this.noConfigs.iterator();
            while (iterator.hasNext()) {
                IBuildConfiguration buildConfig = iterator.next();
                String configName = null;
                ICBuildConfigurationProvider provider = null;
                String[] segments = buildConfig.getName().split("/");
                if (segments.length == 2) {
                    String providerId = segments[0];
                    configName = segments[1];
                    Provider delegate = this.getProviderDelegate(providerId);
                    if (delegate != null && delegate.supports(buildConfig.getProject())) {
                        provider = delegate.getProvider();
                    }
                }
                if (provider == null) continue;
                try {
                    config = provider.getCBuildConfiguration(buildConfig, configName);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (config == null) continue;
                iterator.remove();
                projects.add(buildConfig.getProject());
                this.configs.put(buildConfig, config);
            }
        }
        for (IProject project : projects) {
            CModelManager.getDefault().resetBinaryParser(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICBuildConfiguration getBuildConfiguration(IBuildConfiguration buildConfig) throws CoreException {
        this.initProviders();
        ICBuildConfiguration config = null;
        boolean resetBinaryParser = false;
        Map<IBuildConfiguration, ICBuildConfiguration> map = this.configs;
        synchronized (map) {
            if (this.noConfigs.contains(buildConfig) && this.configs.containsKey(buildConfig)) {
                this.noConfigs.remove(buildConfig);
            }
            if (!this.noConfigs.contains(buildConfig) && (config = this.configs.get(buildConfig)) == null) {
                String configName = null;
                ICBuildConfigurationProvider provider = null;
                String[] segments = buildConfig.getName().split("/");
                if (segments.length == 2) {
                    String providerId = segments[0];
                    configName = segments[1];
                    Provider delegate = this.getProviderDelegate(providerId);
                    if (delegate != null && delegate.supports(buildConfig.getProject())) {
                        provider = delegate.getProvider();
                    }
                }
                if (provider != null) {
                    block13: {
                        try {
                            config = provider.getCBuildConfiguration(buildConfig, configName);
                        }
                        catch (CoreException e) {
                            IStatus status = e.getStatus();
                            if (status.getPlugin().equals("org.eclipse.cdt.core") && status.getCode() == 5) break block13;
                            throw e;
                        }
                    }
                    if (config != null) {
                        this.configs.put(buildConfig, config);
                        resetBinaryParser = true;
                    }
                }
                if (config == null) {
                    this.noConfigs.add(buildConfig);
                }
            }
        }
        if (resetBinaryParser) {
            CModelManager.getDefault().resetBinaryParser(buildConfig.getProject());
        }
        return config;
    }

    @Override
    public ICBuildConfiguration getBuildConfiguration(IProject project, IToolChain toolChain, String launchMode, ILaunchTarget launchTarget, IProgressMonitor monitor) throws CoreException {
        ICBuildConfiguration retVal = this.findCBuildConfiguration(project, toolChain, launchTarget, launchMode, monitor);
        if (retVal == null) {
            retVal = this.createCBuildConfig(project, toolChain, launchTarget, launchMode, monitor);
        }
        return retVal;
    }

    private ICBuildConfiguration findCBuildConfiguration(IProject project, IToolChain toolChain, ILaunchTarget launchTarget, String launchMode, IProgressMonitor monitor) throws CoreException {
        IBuildConfiguration[] iBuildConfigurationArray = project.getBuildConfigs();
        int n = iBuildConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfiguration buildConfig = iBuildConfigurationArray[n2];
            ICBuildConfiguration cBuildConfig = this.getBuildConfiguration(buildConfig);
            if (cBuildConfig != null) {
                IToolChain tc = cBuildConfig.getToolChain();
                ILaunchTarget lt = cBuildConfig.getLaunchTarget();
                String lm = cBuildConfig.getLaunchMode();
                if (tc != null && tc.equals(toolChain) && lt != null && lt.equals(launchTarget) && lm != null && lm.equals(launchMode)) {
                    return cBuildConfig;
                }
            }
            ++n2;
        }
        return null;
    }

    private ICBuildConfiguration createCBuildConfig(IProject project, IToolChain toolChain, ILaunchTarget launchTarget, String launchMode, IProgressMonitor monitor) throws CoreException {
        ICBuildConfiguration retVal = null;
        ICBuildConfigurationProvider provider = this.getProvider(project);
        if (provider != null) {
            retVal = provider.createCBuildConfiguration(project, toolChain, launchMode, launchTarget, monitor);
            if (retVal != null) {
                CCorePlugin.getDefault().resetCachedScannerInfoProvider(project);
                return retVal;
            }
            throw new CoreException(CCorePlugin.createStatus(String.format(Messages.CBuildConfigurationManager_CBuildConfigCreateFail, project.getName(), toolChain.getName(), launchTarget.getId(), launchMode), null));
        }
        throw new CoreException(CCorePlugin.createStatus(String.format(Messages.CBuildConfigurationManager_CBuildConfigProviderNotFound, project.getName(), toolChain.getName(), launchTarget.getId(), launchMode), null));
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if ((event.getType() == 2 || event.getType() == 4) && event.getResource().getType() == 4) {
            IPath scannerInfoPath;
            Path directory;
            Preferences projectNode;
            IProject project = event.getResource().getProject();
            try {
                if (!project.isOpen() || !project.hasNature("org.eclipse.cdt.core.cnature")) {
                    return;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e.getStatus());
                return;
            }
            try {
                IBuildConfiguration[] iBuildConfigurationArray = project.getBuildConfigs();
                int n = iBuildConfigurationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildConfiguration buildConfig = iBuildConfigurationArray[n2];
                    this.configs.remove(buildConfig);
                    ++n2;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
            Preferences parentNode = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").node("config");
            if (parentNode != null && (projectNode = parentNode.node(project.getName())) != null) {
                try {
                    if (event.getType() == 4) {
                        projectNode.removeNode();
                    }
                    parentNode.flush();
                }
                catch (BackingStoreException e) {
                    CCorePlugin.log(e);
                }
            }
            if (!Files.exists(directory = (scannerInfoPath = CCorePlugin.getDefault().getStateLocation().append("infoCache").append(project.getName())).toFile().toPath(), new LinkOption[0])) {
                return;
            }
            try {
                Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                CCorePlugin.log(e);
            }
        }
    }

    @Override
    public boolean supports(IProject project) throws CoreException {
        if (!CoreModel.hasCNature(project)) {
            return false;
        }
        this.initProviders();
        IBuildConfiguration[] iBuildConfigurationArray = project.getBuildConfigs();
        int n = iBuildConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfiguration config = iBuildConfigurationArray[n2];
            if (this.configs.containsKey(config)) {
                return true;
            }
            ++n2;
        }
        for (Provider provider : this.providers.values()) {
            if (!provider.supports(project)) continue;
            return true;
        }
        return false;
    }

    private static class Provider {
        private String id;
        private String natureId;
        private IConfigurationElement element;
        private ICBuildConfigurationProvider provider;

        public Provider(IConfigurationElement element) {
            this.id = element.getAttribute("id");
            this.natureId = element.getAttribute("natureId");
            this.element = element;
        }

        public String getId() {
            return this.id;
        }

        public ICBuildConfigurationProvider getProvider() {
            if (this.provider == null) {
                try {
                    this.provider = (ICBuildConfigurationProvider)this.element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    CCorePlugin.log(e.getStatus());
                }
            }
            return this.provider;
        }

        public boolean supports(IProject project) {
            try {
                if (this.natureId != null) {
                    return project.hasNature(this.natureId);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e.getStatus());
            }
            return false;
        }
    }
}

