/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IDataDrivenRuntimeObject;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenOutputEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenPresentationState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenTimeGraphDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class DataDrivenTimeGraphProviderFactory
implements IDataDrivenRuntimeObject {
    private final List<DataDrivenPresentationState> fValues;
    private final List<DataDrivenOutputEntry> fEntries;
    private final Set<String> fAnalysisIds;

    public DataDrivenTimeGraphProviderFactory(List<DataDrivenOutputEntry> entries, Set<String> analysisIds, List<DataDrivenPresentationState> values) {
        this.fValues = values;
        this.fEntries = entries;
        this.fAnalysisIds = analysisIds;
    }

    public @Nullable ITimeGraphDataProvider<TimeGraphEntryModel> create(ITmfTrace trace) {
        HashSet<@NonNull ITmfAnalysisModuleWithStateSystems> stateSystemModules = new HashSet<ITmfAnalysisModuleWithStateSystems>();
        ArrayList<ITmfStateSystem> sss = new ArrayList<ITmfStateSystem>();
        if (this.fAnalysisIds.isEmpty()) {
            Iterables.addAll(stateSystemModules, (Iterable)TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ITmfAnalysisModuleWithStateSystems.class));
        } else {
            for (String moduleId : this.fAnalysisIds) {
                IAnalysisModule module = trace.getAnalysisModule(moduleId);
                if (!(module instanceof ITmfAnalysisModuleWithStateSystems)) continue;
                stateSystemModules.add((ITmfAnalysisModuleWithStateSystems)module);
            }
        }
        for (ITmfAnalysisModuleWithStateSystems module : stateSystemModules) {
            if (!module.schedule().isOK() || !module.waitForInitialization()) continue;
            module.getStateSystems().forEach(sss::add);
        }
        return sss.isEmpty() ? null : DataDrivenTimeGraphProviderFactory.create(trace, sss, this.fEntries, this.fValues, null);
    }

    public static ITimeGraphDataProvider<TimeGraphEntryModel> create(ITmfTrace trace, List<ITmfStateSystem> stateSystems, List<DataDrivenOutputEntry> entries, List<DataDrivenPresentationState> values, @Nullable String id) {
        return new DataDrivenTimeGraphDataProvider(trace, stateSystems, entries, values, id);
    }
}

