/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messageflow;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.Ros2ObjectTimeGraphEntryModel;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.Ros2ObjectTimeGraphEntryModelType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messageflow.Ros2MessageFlowAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2CallbackTimeGraphState;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesDataProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2PubTimeGraphState;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2TakeTimeGraphState;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.IRos2MessageFlowVisitor;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2CallbackPubMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowModel;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowTraverser;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2PublicationMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2SubCallbackMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2TimerCallbackMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2TransportMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2WaitMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2CallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2PubInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2SubCallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2NodeObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2TimerObject;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Ros2MessageFlowDataProvider
extends AbstractTmfTraceDataProvider
implements ITimeGraphDataProvider<TimeGraphEntryModel> {
    public static final String SUFFIX = ".dataprovider";
    private static final AtomicLong ATOMIC_LONG = new AtomicLong();
    private final @NonNull ITmfStateSystem fObjectsSs;
    private final @NonNull Ros2MessageFlowAnalysis fAnalysis;
    private final long fStartTime;
    private final long fEndTime;
    private final BiMap<Ros2ObjectHandle, Long> fObjectHandleToEntryId = HashBiMap.create();
    private final BiMap<String, Long> fTraceNameToEntryId = HashBiMap.create();

    public Ros2MessageFlowDataProvider(@NonNull ITmfTrace trace, @NonNull Ros2MessageFlowAnalysis analysis) {
        super(trace);
        this.fAnalysis = analysis;
        this.fObjectsSs = Objects.requireNonNull(TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)Ros2ObjectsAnalysis.getFullAnalysisId()));
        this.fStartTime = trace.getStartTime().toNanos();
        this.fEndTime = trace.getEndTime().toNanos();
    }

    public @NonNull String getId() {
        return Ros2MessageFlowDataProvider.getFullDataProviderId();
    }

    private long getTraceEntryId(String traceName) {
        return (Long)this.fTraceNameToEntryId.computeIfAbsent((Object)traceName, i -> ATOMIC_LONG.getAndIncrement());
    }

    private long getObjectEntryId(Ros2ObjectHandle handle) {
        return (Long)this.fObjectHandleToEntryId.computeIfAbsent((Object)handle, i -> ATOMIC_LONG.getAndIncrement());
    }

    public @NonNull TmfModelResponse<@NonNull TmfTreeModel<@NonNull TimeGraphEntryModel>> fetchTree(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Ros2MessageFlowModel model = this.fAnalysis.getModel();
        if (model == null || !model.isDone()) {
            return new TmfModelResponse(null, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
        }
        ArrayList<@NonNull TimeGraphEntryModel> entries = new ArrayList<TimeGraphEntryModel>();
        long rootId = ATOMIC_LONG.getAndIncrement();
        entries.add(new TimeGraphEntryModel(rootId, -1L, String.valueOf(this.getTrace().getName()), this.fStartTime, this.fEndTime));
        MessageFlowObjectAggregator aggregator = new MessageFlowObjectAggregator(rootId, entries);
        Ros2MessageFlowTraverser traverser = new Ros2MessageFlowTraverser(aggregator);
        traverser.traverse(model.getInitialSegment());
        return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), entries), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull TmfModelResponse<@NonNull TimeGraphModel> fetchRowModel(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Ros2MessageFlowModel model = this.fAnalysis.getModel();
        if (model == null || !model.isDone()) {
            return new TmfModelResponse(null, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
        }
        @NonNull HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(fetchParameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        MessageFlowRowModelCollector collector = new MessageFlowRowModelCollector();
        Ros2MessageFlowTraverser traverser = new Ros2MessageFlowTraverser(collector);
        traverser.traverse(model.getInitialSegment());
        return new TmfModelResponse((Object)new TimeGraphModel(collector.getRows()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        Ros2MessageFlowModel model = this.fAnalysis.getModel();
        if (model == null || !model.isDone()) {
            return new TmfModelResponse(null, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
        }
        MessageFlowArrowsCollector arrowsCollector = new MessageFlowArrowsCollector(filter.getStart(), filter.getEnd());
        Ros2MessageFlowTraverser traverser = new Ros2MessageFlowTraverser(arrowsCollector);
        traverser.traverse(model.getInitialSegment());
        return new TmfModelResponse(arrowsCollector.getArrows(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public static @NonNull String getFullDataProviderId() {
        return Ros2MessageFlowAnalysis.getFullAnalysisId() + SUFFIX;
    }

    private class MessageFlowArrowsCollector
    implements IRos2MessageFlowVisitor {
        private final long fStart;
        private final long fEnd;
        private final List<@NonNull ITimeGraphArrow> fArrows = new ArrayList<ITimeGraphArrow>();

        public List<@NonNull ITimeGraphArrow> getArrows() {
            return this.fArrows;
        }

        public MessageFlowArrowsCollector(long startTime, long endTime) {
            this.fStart = startTime;
            this.fEnd = endTime;
        }

        @Override
        public void visit(@NonNull Ros2MessageFlowSegment segment) {
            Ros2MessagesDataProvider.ArrowType arrowType;
            long destinationId;
            long sourceId;
            if (!segment.isLink()) {
                return;
            }
            if (segment.getStartTime() > this.fEnd || segment.getEndTime() < this.fStart) {
                return;
            }
            if (segment instanceof Ros2TransportMessageFlowSegment) {
                Ros2TransportMessageFlowSegment transportSegment = (Ros2TransportMessageFlowSegment)segment;
                sourceId = Ros2MessageFlowDataProvider.this.getObjectEntryId((Ros2ObjectHandle)((Object)transportSegment.getPublisher().getHandle()));
                destinationId = Ros2MessageFlowDataProvider.this.getObjectEntryId((Ros2ObjectHandle)((Object)transportSegment.getSubscription().getHandle()));
                arrowType = Ros2MessagesDataProvider.ArrowType.TRANSPORT;
            } else if (segment instanceof Ros2CallbackPubMessageFlowSegment) {
                Ros2CallbackPubMessageFlowSegment callbackPubSegment = (Ros2CallbackPubMessageFlowSegment)segment;
                sourceId = Ros2MessageFlowDataProvider.this.getObjectEntryId(callbackPubSegment.getSource().getHandle());
                destinationId = Ros2MessageFlowDataProvider.this.getObjectEntryId((Ros2ObjectHandle)((Object)callbackPubSegment.getPublisher().getHandle()));
                arrowType = Ros2MessagesDataProvider.ArrowType.CALLBACK_PUB;
            } else if (segment instanceof Ros2WaitMessageFlowSegment) {
                Ros2WaitMessageFlowSegment waitSegment = (Ros2WaitMessageFlowSegment)segment;
                sourceId = Ros2MessageFlowDataProvider.this.getObjectEntryId((Ros2ObjectHandle)((Object)waitSegment.getSubscription().getHandle()));
                destinationId = Ros2MessageFlowDataProvider.this.getObjectEntryId((Ros2ObjectHandle)((Object)waitSegment.getPublisher().getHandle()));
                arrowType = Ros2MessagesDataProvider.ArrowType.WAIT;
            } else {
                throw new IllegalStateException();
            }
            long time = segment.getStartTime();
            long duration = segment.getEndTime() - segment.getStartTime();
            this.fArrows.add((ITimeGraphArrow)new TimeGraphArrow(sourceId, destinationId, time, duration, arrowType.getId()));
        }
    }

    private class MessageFlowObjectAggregator
    implements IRos2MessageFlowVisitor {
        private final long fRootId;
        private final @NonNull List<@NonNull TimeGraphEntryModel> fEntries;
        private final HashMap<@NonNull String, @NonNull Ros2NodeObject> fTraceNodes = new HashMap();
        private final HashSet<@NonNull Ros2ObjectHandle> fNodeObjectHandles = new HashSet();
        private final HashSet<@NonNull Ros2NodeObject> fNodeObjects = new HashSet();
        private final HashSet<@NonNull Ros2PublisherObject> fPublisherObjects = new HashSet();
        private final HashSet<@NonNull Ros2SubscriptionObject> fSubscriptionObjects = new HashSet();
        private final HashSet<@NonNull Ros2TimerObject> fTimerObjects = new HashSet();

        public MessageFlowObjectAggregator(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NonNull @NonNull long rootId, List<TimeGraphEntryModel> entries) {
            this.fRootId = rootId;
            this.fEntries = entries;
        }

        @Override
        public void visit(@NonNull Ros2MessageFlowSegment segment) {
            if (!segment.isLink()) {
                this.fNodeObjectHandles.add(Objects.requireNonNull(segment.getNodeHandle()));
            }
            if (segment instanceof Ros2SubCallbackMessageFlowSegment) {
                this.fSubscriptionObjects.add(((Ros2SubCallbackMessageFlowSegment)segment).getSubscription());
            } else if (segment instanceof Ros2TimerCallbackMessageFlowSegment) {
                this.fTimerObjects.add(((Ros2TimerCallbackMessageFlowSegment)segment).getTimer());
            } else if (segment instanceof Ros2PublicationMessageFlowSegment) {
                this.fPublisherObjects.add(((Ros2PublicationMessageFlowSegment)segment).getPublisher());
            } else if (segment instanceof Ros2TransportMessageFlowSegment) {
                Ros2TransportMessageFlowSegment transportSegment = (Ros2TransportMessageFlowSegment)segment;
                this.fPublisherObjects.add(transportSegment.getPublisher());
                this.fSubscriptionObjects.add(transportSegment.getSubscription());
            } else if (segment instanceof Ros2CallbackPubMessageFlowSegment) {
                this.fPublisherObjects.add(((Ros2CallbackPubMessageFlowSegment)segment).getPublisher());
            } else if (segment instanceof Ros2WaitMessageFlowSegment) {
                Ros2WaitMessageFlowSegment waitSegment = (Ros2WaitMessageFlowSegment)segment;
                this.fSubscriptionObjects.add(waitSegment.getSubscription());
                this.fPublisherObjects.add(waitSegment.getPublisher());
            } else {
                throw new IllegalStateException();
            }
        }

        @Override
        public void postVisit() {
            long parentEntryId;
            for (Ros2ObjectHandle ros2ObjectHandle : this.fNodeObjectHandles) {
                Ros2NodeObject nodeObject = Ros2ObjectsUtil.getNodeObjectFromHandle(Ros2MessageFlowDataProvider.this.fObjectsSs, ros2ObjectHandle);
                if (nodeObject == null) continue;
                this.fNodeObjects.add(nodeObject);
                this.fTraceNodes.put(nodeObject.getTraceName(), nodeObject);
            }
            for (Map.Entry entry : this.fTraceNodes.entrySet()) {
                long entryId = Ros2MessageFlowDataProvider.this.getTraceEntryId((String)entry.getKey());
                this.fEntries.add(new Ros2ObjectTimeGraphEntryModel(entryId, this.fRootId, Ros2MessageFlowDataProvider.this.fStartTime, Ros2MessageFlowDataProvider.this.fEndTime, Ros2ObjectTimeGraphEntryModelType.TRACE, entry.getValue()));
            }
            for (Ros2NodeObject ros2NodeObject : this.fNodeObjects) {
                long entryId = Ros2MessageFlowDataProvider.this.getObjectEntryId((Ros2ObjectHandle)((Object)ros2NodeObject.getHandle()));
                parentEntryId = Ros2MessageFlowDataProvider.this.getTraceEntryId(ros2NodeObject.getTraceName());
                this.fEntries.add(new Ros2ObjectTimeGraphEntryModel(entryId, parentEntryId, Ros2MessageFlowDataProvider.this.fStartTime, Ros2MessageFlowDataProvider.this.fEndTime, Ros2ObjectTimeGraphEntryModelType.NODE, (Object)ros2NodeObject));
            }
            for (Ros2PublisherObject ros2PublisherObject : this.fPublisherObjects) {
                long entryId = Ros2MessageFlowDataProvider.this.getObjectEntryId((Ros2ObjectHandle)((Object)ros2PublisherObject.getHandle()));
                parentEntryId = Ros2MessageFlowDataProvider.this.getObjectEntryId(ros2PublisherObject.getNodeHandle());
                this.fEntries.add(new Ros2ObjectTimeGraphEntryModel(entryId, parentEntryId, Ros2MessageFlowDataProvider.this.fStartTime, Ros2MessageFlowDataProvider.this.fEndTime, Ros2ObjectTimeGraphEntryModelType.PUBLISHER, (Object)ros2PublisherObject));
            }
            for (Ros2SubscriptionObject ros2SubscriptionObject : this.fSubscriptionObjects) {
                long entryId = Ros2MessageFlowDataProvider.this.getObjectEntryId((Ros2ObjectHandle)((Object)ros2SubscriptionObject.getHandle()));
                parentEntryId = Ros2MessageFlowDataProvider.this.getObjectEntryId(ros2SubscriptionObject.getNodeHandle());
                this.fEntries.add(new Ros2ObjectTimeGraphEntryModel(entryId, parentEntryId, Ros2MessageFlowDataProvider.this.fStartTime, Ros2MessageFlowDataProvider.this.fEndTime, Ros2ObjectTimeGraphEntryModelType.SUBSCRIPTION, (Object)ros2SubscriptionObject));
            }
            for (Ros2TimerObject ros2TimerObject : this.fTimerObjects) {
                long entryId = Ros2MessageFlowDataProvider.this.getObjectEntryId((Ros2ObjectHandle)((Object)ros2TimerObject.getHandle()));
                parentEntryId = Ros2MessageFlowDataProvider.this.getObjectEntryId(ros2TimerObject.getNodeHandle());
                this.fEntries.add(new Ros2ObjectTimeGraphEntryModel(entryId, parentEntryId, Ros2MessageFlowDataProvider.this.fStartTime, Ros2MessageFlowDataProvider.this.fEndTime, Ros2ObjectTimeGraphEntryModelType.TIMER, (Object)ros2TimerObject));
            }
        }
    }

    private class MessageFlowRowModelCollector
    implements IRos2MessageFlowVisitor {
        private Multimap<@NonNull Ros2ObjectHandle, @NonNull ITimeGraphState> fEvents = HashMultimap.create();
        private @NonNull List<@NonNull ITimeGraphRowModel> fRows = new ArrayList<ITimeGraphRowModel>();

        private MessageFlowRowModelCollector() {
        }

        public @NonNull List<@NonNull ITimeGraphRowModel> getRows() {
            return this.fRows;
        }

        @Override
        public void visit(@NonNull Ros2MessageFlowSegment segment) {
            if (segment.isLink()) {
                return;
            }
            if (segment instanceof Ros2SubCallbackMessageFlowSegment) {
                Ros2SubCallbackMessageFlowSegment subCallbackSegment = (Ros2SubCallbackMessageFlowSegment)segment;
                Ros2SubCallbackInstance subCallbackInstance = subCallbackSegment.getCallbackInstance();
                Ros2TakeTimeGraphState takeState = new Ros2TakeTimeGraphState(subCallbackInstance.getTakeInstance());
                this.fEvents.put((Object)subCallbackInstance.getCallbackInstance().getOwnerHandle(), (Object)takeState);
                Ros2CallbackTimeGraphState callbackState = new Ros2CallbackTimeGraphState(subCallbackInstance.getCallbackInstance());
                this.fEvents.put((Object)subCallbackInstance.getCallbackInstance().getOwnerHandle(), (Object)callbackState);
            } else if (segment instanceof Ros2TimerCallbackMessageFlowSegment) {
                Ros2TimerCallbackMessageFlowSegment timerCallbackSegment = (Ros2TimerCallbackMessageFlowSegment)segment;
                Ros2CallbackInstance timerCallbackInstance = timerCallbackSegment.getCallbackInstance();
                Ros2CallbackTimeGraphState timerCallbackState = new Ros2CallbackTimeGraphState(timerCallbackInstance);
                this.fEvents.put((Object)timerCallbackInstance.getOwnerHandle(), (Object)timerCallbackState);
            } else if (segment instanceof Ros2PublicationMessageFlowSegment) {
                Ros2PublicationMessageFlowSegment pubSegment = (Ros2PublicationMessageFlowSegment)segment;
                Ros2PubInstance pubInstance = pubSegment.getPubInstance();
                Ros2PubTimeGraphState pubState = new Ros2PubTimeGraphState(segment.getStartTime(), segment.getEndTime() - segment.getStartTime() + 1L, pubInstance);
                this.fEvents.put((Object)pubInstance.getPublisherHandle(), (Object)pubState);
            }
        }

        @Override
        public void postVisit() {
            for (Map.Entry entry : this.fEvents.asMap().entrySet()) {
                long entryId = Ros2MessageFlowDataProvider.this.getObjectEntryId((Ros2ObjectHandle)((Object)entry.getKey()));
                ArrayList<@NonNull E> eventList = new ArrayList((Collection)entry.getValue());
                this.fRows.add((ITimeGraphRowModel)new TimeGraphRowModel(entryId, eventList));
            }
        }
    }
}

