/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.core.analysis.spanlife;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.analysis.spanlife.SpanLifeAnalysis;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.analysis.spanlife.SpanLifeDataProvider;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class SpanLifeDataProviderFactory
implements IDataProviderFactory {
    private static final Predicate<? super ITmfTrace> PREDICATE = t -> TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)t, SpanLifeAnalysis.class, (String)"org.eclipse.tracecompass.incubator.opentracing.analysis.spanlife") != null;
    private static final IDataProviderDescriptor DESCRIPTOR = new DataProviderDescriptor.Builder().setId(SpanLifeDataProvider.ID).setName("Span Life").setDescription("Show spans over time").setProviderType(IDataProviderDescriptor.ProviderType.TIME_GRAPH).build();

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(@NonNull ITmfTrace trace) {
        SpanLifeAnalysis module = (SpanLifeAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, SpanLifeAnalysis.class, (String)"org.eclipse.tracecompass.incubator.opentracing.analysis.spanlife");
        if (module != null) {
            module.schedule();
            return new SpanLifeDataProvider(trace, module);
        }
        return null;
    }

    public Collection<IDataProviderDescriptor> getDescriptors(@NonNull ITmfTrace trace) {
        Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        return Iterables.any((Iterable)traces, PREDICATE) ? Collections.singletonList(DESCRIPTOR) : Collections.emptyList();
    }
}

