/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2CallbackType;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

public class Ros2CallbackPublicationInstance
extends CustomStateValue {
    public static final byte CUSTOM_TYPE_ID = 71;
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CustomStateValue.CustomStateValueFactory ROS2_CALLBACK_PUBLICATION_INSTANCE_VALUE_FACTORY = Ros2CallbackPublicationInstance::read;
    private final @NonNull Ros2ObjectHandle fCallbackOwnerHandle;
    private final @NonNull Ros2ObjectHandle fPublisherHandle;
    private final long fPublicationTimestamp;
    private final @NonNull Ros2CallbackType fCallbackType;

    public Ros2CallbackPublicationInstance(@NonNull Ros2ObjectHandle callbackOwnerHandle, @NonNull Ros2ObjectHandle publisherHandle, long publicationTimestamp, @NonNull Ros2CallbackType callbackType) {
        this.fCallbackOwnerHandle = callbackOwnerHandle;
        this.fPublisherHandle = publisherHandle;
        this.fPublicationTimestamp = publicationTimestamp;
        this.fCallbackType = callbackType;
    }

    public @NonNull Ros2ObjectHandle getCallbackOwnerHandle() {
        return this.fCallbackOwnerHandle;
    }

    public @NonNull Ros2ObjectHandle getPublisherHandle() {
        return this.fPublisherHandle;
    }

    public long getPublicationTimestamp() {
        return this.fPublicationTimestamp;
    }

    public @NonNull Ros2CallbackType getCallbackType() {
        return this.fCallbackType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fCallbackOwnerHandle, this.fPublisherHandle, this.fPublicationTimestamp, this.fCallbackType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Ros2CallbackPublicationInstance o = (Ros2CallbackPublicationInstance)((Object)obj);
        return o.fCallbackOwnerHandle.equals((Object)this.fCallbackOwnerHandle) && o.fPublisherHandle.equals((Object)this.fPublisherHandle) && o.fPublicationTimestamp == this.fPublicationTimestamp && o.fCallbackType.equals((Object)this.fCallbackType);
    }

    public int compareTo(@NonNull ITmfStateValue o) {
        return this.equals(o) ? 0 : -1;
    }

    public String toString() {
        return String.format("Ros2CallbackPublicationInstance: callbackOwner=[%s], pub=[%s], publicationTimestamp=%s, callbackType=%s", this.fCallbackOwnerHandle.toString(), this.fPublisherHandle.toString(), this.fPublicationTimestamp, this.fCallbackType.toString());
    }

    protected @NonNull Byte getCustomTypeId() {
        return (byte)71;
    }

    protected void serializeValue(@NonNull ISafeByteBufferWriter buffer) {
        this.fCallbackOwnerHandle.serializeValue(buffer);
        this.fPublisherHandle.serializeValue(buffer);
        buffer.putLong(this.fPublicationTimestamp);
        buffer.putInt(this.fCallbackType.ordinal());
    }

    protected int getSerializedValueSize() {
        int size = 0;
        size += this.fCallbackOwnerHandle.getSerializedValueSize();
        size += this.fPublisherHandle.getSerializedValueSize();
        size += 8;
        return size += 4;
    }

    public static @NonNull Ros2CallbackPublicationInstance read(ISafeByteBufferReader buffer) {
        Ros2ObjectHandle callbackOwnerHandle = Ros2ObjectHandle.read(buffer);
        Ros2ObjectHandle publisherHandle = Ros2ObjectHandle.read(buffer);
        long publicationTimestamp = buffer.getLong();
        Ros2CallbackType callbackType = Ros2CallbackType.values()[buffer.getInt()];
        return new Ros2CallbackPublicationInstance(callbackOwnerHandle, publisherHandle, publicationTimestamp, callbackType);
    }
}

