/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.project.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.project.model.Messages;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypePreferences;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public final class TmfTraceType {
    public static final String TMF_TRACE_TYPE_ID = "org.eclipse.linuxtools.tmf.core.tracetype";
    public static final String CATEGORY_ELEM = "category";
    public static final String TYPE_ELEM = "type";
    public static final String EXPERIMENT_ELEM = "experiment";
    public static final String ID_ATTR = "id";
    public static final String NAME_ATTR = "name";
    public static final String CATEGORY_ATTR = "category";
    public static final String TRACE_TYPE_ATTR = "trace_type";
    public static final String EVENT_TYPE_ATTR = "event_type";
    public static final String EXPERIMENT_TYPE_ATTR = "experiment_type";
    public static final String IS_DIR_ATTR = "isDirectory";
    public static final String DEFAULT_EXPERIMENT_TYPE = "org.eclipse.linuxtools.tmf.core.experiment.generic";
    private static final Map<String, IConfigurationElement> TRACE_TYPE_ATTRIBUTES = new HashMap<String, IConfigurationElement>();
    private static final Map<String, IConfigurationElement> TRACE_CATEGORIES = new HashMap<String, IConfigurationElement>();
    private static final Map<String, @NonNull TraceTypeHelper> TRACE_TYPES = new LinkedHashMap<String, TraceTypeHelper>();

    static {
        TmfTraceType.populateCategoriesAndTraceTypes();
        TmfTraceType.populateCustomTraceTypes();
        TmfTraceType.enableTraceTypes();
    }

    private TmfTraceType() {
    }

    public static Iterable<@NonNull TraceTypeHelper> getTraceTypeHelpers() {
        return TRACE_TYPES.values();
    }

    public static String[] getAvailableTraceTypes() {
        return TmfTraceType.getAvailableTraceTypes(null);
    }

    public static String[] getAvailableTraceTypes(Comparator<String> comparator) {
        ArrayList<String> traceTypes = new ArrayList<String>();
        for (TraceTypeHelper tt : TmfTraceType.getTraceTypeHelpers()) {
            if (!tt.isEnabled() || tt.isExperimentType()) continue;
            traceTypes.add(tt.getLabel());
        }
        if (comparator == null) {
            Collections.sort(traceTypes);
        } else {
            Collections.sort(traceTypes, comparator);
        }
        return traceTypes.toArray(new String[traceTypes.size()]);
    }

    private static void populateCustomTraceTypes() {
        TraceTypeHelper tt;
        String traceTypeId;
        TmfTrace trace;
        CustomTraceDefinition def;
        CustomTraceDefinition[] customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
        int n = customTraceDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            def = customTraceDefinitionArray[n2];
            trace = new CustomTxtTrace((CustomTxtTraceDefinition)def);
            traceTypeId = ((CustomTxtTrace)trace).getTraceTypeId();
            tt = new TraceTypeHelper(traceTypeId, def.categoryName, def.definitionName, trace, false, TraceElementType.TRACE);
            TRACE_TYPES.put(traceTypeId, tt);
            TmfSignalManager.deregister(trace);
            ++n2;
        }
        customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
        n = customTraceDefinitionArray.length;
        n2 = 0;
        while (n2 < n) {
            def = customTraceDefinitionArray[n2];
            trace = new CustomXmlTrace((CustomXmlTraceDefinition)def);
            traceTypeId = ((CustomXmlTrace)trace).getTraceTypeId();
            tt = new TraceTypeHelper(traceTypeId, ((CustomXmlTraceDefinition)def).categoryName, ((CustomXmlTraceDefinition)def).definitionName, trace, false, TraceElementType.TRACE);
            TRACE_TYPES.put(traceTypeId, tt);
            TmfSignalManager.deregister(trace);
            ++n2;
        }
    }

    public static void addCustomTraceType(Class<? extends ITmfTrace> traceClass, String category, String definitionName) {
        CustomTraceDefinition def;
        String traceTypeId = null;
        TmfTrace trace = null;
        if (traceClass.equals(CustomTxtTrace.class)) {
            def = CustomTxtTraceDefinition.load(category, definitionName);
            if (def != null) {
                trace = new CustomTxtTrace((CustomTxtTraceDefinition)def);
                traceTypeId = trace.getTraceTypeId();
            }
        } else if (traceClass.equals(CustomXmlTrace.class) && (def = CustomXmlTraceDefinition.load(category, definitionName)) != null) {
            trace = new CustomXmlTrace((CustomXmlTraceDefinition)def);
            traceTypeId = trace.getTraceTypeId();
        }
        if (traceTypeId != null && trace != null) {
            TraceTypeHelper helper = TRACE_TYPES.get(traceTypeId);
            if (helper != null) {
                helper.getTrace().dispose();
            }
            TraceTypeHelper tt = new TraceTypeHelper(traceTypeId, category, definitionName, trace, false, TraceElementType.TRACE);
            TRACE_TYPES.put(traceTypeId, tt);
            TmfSignalManager.deregister(trace);
        }
    }

    public static void removeCustomTraceType(Class<? extends ITmfTrace> traceClass, String category, String definitionName) {
        TraceTypeHelper helper;
        String traceTypeId = null;
        if (traceClass.equals(CustomTxtTrace.class)) {
            traceTypeId = CustomTxtTrace.buildTraceTypeId(category, definitionName);
        } else if (traceClass.equals(CustomXmlTrace.class)) {
            traceTypeId = CustomXmlTrace.buildTraceTypeId(category, definitionName);
        }
        if (traceTypeId != null && (helper = TRACE_TYPES.remove(traceTypeId)) != null) {
            helper.getTrace().dispose();
        }
    }

    public static TraceTypeHelper getTraceType(String id) {
        return TRACE_TYPES.get(id);
    }

    public static @Nullable ITmfTrace instantiateTrace(@NonNull String traceTypeId) throws CoreException {
        IConfigurationElement ce;
        String id;
        CustomTraceDefinition def;
        int n;
        int n2;
        CustomTraceDefinition[] customTraceDefinitionArray;
        if (CustomTxtTrace.isCustomTraceTypeId(traceTypeId)) {
            customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
            n2 = customTraceDefinitionArray.length;
            n = 0;
            while (n < n2) {
                def = customTraceDefinitionArray[n];
                id = CustomTxtTrace.buildTraceTypeId(((CustomTxtTraceDefinition)def).categoryName, ((CustomTxtTraceDefinition)def).definitionName);
                if (traceTypeId.equals(id)) {
                    return new CustomTxtTrace((CustomTxtTraceDefinition)def);
                }
                ++n;
            }
        }
        if (CustomXmlTrace.isCustomTraceTypeId(traceTypeId)) {
            customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
            n2 = customTraceDefinitionArray.length;
            n = 0;
            while (n < n2) {
                def = customTraceDefinitionArray[n];
                id = CustomXmlTrace.buildTraceTypeId(((CustomXmlTraceDefinition)def).categoryName, ((CustomXmlTraceDefinition)def).definitionName);
                if (traceTypeId.equals(id)) {
                    return new CustomXmlTrace((CustomXmlTraceDefinition)def);
                }
                ++n;
            }
        }
        if ((ce = TRACE_TYPE_ATTRIBUTES.get(traceTypeId)) == null) {
            return null;
        }
        return (ITmfTrace)ce.createExecutableExtension(TRACE_TYPE_ATTR);
    }

    private static void enableTraceTypes() {
        List<String> preferences = TraceTypePreferences.getPreferenceValue();
        TRACE_TYPES.values().forEach(helper -> {
            if (!helper.isExperimentType()) {
                helper.setEnabled(!preferences.contains(helper.getTraceTypeId()));
            }
        });
    }

    private static void populateCategoriesAndTraceTypes() {
        if (TRACE_TYPES.isEmpty()) {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_TRACE_TYPE_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                String elementName = ce.getName();
                if (elementName.equals(TYPE_ELEM)) {
                    String traceTypeId = ce.getAttribute(ID_ATTR);
                    TRACE_TYPE_ATTRIBUTES.put(traceTypeId, ce);
                } else if (elementName.equals("category")) {
                    String categoryId = ce.getAttribute(ID_ATTR);
                    TRACE_CATEGORIES.put(categoryId, ce);
                } else if (elementName.equals(EXPERIMENT_ELEM)) {
                    String experimentTypeId = ce.getAttribute(ID_ATTR);
                    TRACE_TYPE_ATTRIBUTES.put(experimentTypeId, ce);
                }
                ++n2;
            }
            for (Map.Entry<String, IConfigurationElement> entry : TRACE_TYPE_ATTRIBUTES.entrySet()) {
                IConfigurationElement ce = entry.getValue();
                String category = TmfTraceType.getCategory(ce);
                String attribute = ce.getAttribute(NAME_ATTR);
                ITmfTrace trace = null;
                TraceElementType elementType = TraceElementType.TRACE;
                try {
                    if (ce.getName().equals(TYPE_ELEM)) {
                        trace = (ITmfTrace)ce.createExecutableExtension(TRACE_TYPE_ATTR);
                    } else if (ce.getName().equals(EXPERIMENT_ELEM)) {
                        trace = (ITmfTrace)ce.createExecutableExtension(EXPERIMENT_TYPE_ATTR);
                        elementType = TraceElementType.EXPERIMENT;
                    }
                    if (trace == null) break;
                    TmfSignalManager.deregister(trace);
                    String dirString = ce.getAttribute(IS_DIR_ATTR);
                    boolean isDir = Boolean.parseBoolean(dirString);
                    String typeId = entry.getKey();
                    TraceTypeHelper tt = new TraceTypeHelper(typeId, category, attribute, trace, isDir, elementType);
                    TRACE_TYPES.put(typeId, tt);
                }
                catch (CoreException e) {
                    Activator.logError("Unexpected error during populating trace types", e);
                }
            }
        }
    }

    private static String getCategory(IConfigurationElement ce) {
        IConfigurationElement category;
        String categoryId = ce.getAttribute("category");
        if (categoryId != null && (category = TRACE_CATEGORIES.get(categoryId)) != null && !category.getName().equals("")) {
            return category.getAttribute(NAME_ATTR);
        }
        return "";
    }

    public static IConfigurationElement getTraceAttributes(String traceType) {
        return TRACE_TYPE_ATTRIBUTES.get(traceType);
    }

    public static String getTraceTypeId(String label) {
        for (Map.Entry<String, TraceTypeHelper> entry : TRACE_TYPES.entrySet()) {
            if (!entry.getValue().getLabel().equals(label)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean isDirectoryTrace(String path) {
        Iterable<TraceTypeHelper> traceTypeHelpers = TmfTraceType.getTraceTypeHelpers();
        for (TraceTypeHelper traceTypeHelper : traceTypeHelpers) {
            if (!traceTypeHelper.isDirectoryTraceType() || traceTypeHelper.validate(path).getSeverity() == 4) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectoryTraceType(String traceType) {
        if (traceType != null) {
            TraceTypeHelper traceTypeHelper = TmfTraceType.getTraceType(traceType);
            if (traceTypeHelper != null) {
                return traceTypeHelper.isDirectoryTraceType();
            }
            return false;
        }
        throw new IllegalArgumentException("Invalid trace type string: " + traceType);
    }

    public static String getTraceTypeId(IResource resource) throws CoreException {
        String traceTypeId = (String)resource.getPersistentProperties().get(TmfCommonConstants.TRACETYPE);
        return TmfTraceType.buildCompatibilityTraceTypeId(traceTypeId);
    }

    public static String buildCompatibilityTraceTypeId(String traceTypeId) {
        if (traceTypeId != null) {
            String newTraceType = CustomTxtTrace.buildCompatibilityTraceTypeId(traceTypeId);
            if (newTraceType.equals(traceTypeId)) {
                newTraceType = CustomXmlTrace.buildCompatibilityTraceTypeId(traceTypeId);
            }
            return newTraceType;
        }
        return traceTypeId;
    }

    public static @NonNull List<TraceTypeHelper> selectTraceType(String path, String traceTypeHint) throws TmfTraceImportException {
        Comparator comparator = (o1, o2) -> {
            int res = ((Integer)o2.getFirst()).compareTo((Integer)o1.getFirst());
            if (res == 0) {
                res = ((TraceTypeHelper)o1.getSecond()).getName().compareTo(((TraceTypeHelper)o2.getSecond()).getName());
            }
            return res;
        };
        TreeSet<Pair<Integer, TraceTypeHelper>> validCandidates = new TreeSet<Pair<Integer, TraceTypeHelper>>(comparator);
        Iterable<TraceTypeHelper> traceTypeHelpers = TmfTraceType.getTraceTypeHelpers();
        for (TraceTypeHelper traceTypeHelper : traceTypeHelpers) {
            int confidence;
            if (!traceTypeHelper.isEnabled() || traceTypeHelper.isExperimentType() || (confidence = traceTypeHelper.validateWithConfidence(path)) < 0) continue;
            if (traceTypeHelper.getTraceTypeId().equals(traceTypeHint)) {
                return Collections.singletonList(traceTypeHelper);
            }
            Pair<Integer, TraceTypeHelper> element = new Pair<Integer, TraceTypeHelper>(confidence, traceTypeHelper);
            validCandidates.add(element);
        }
        ArrayList<TraceTypeHelper> returned = new ArrayList<TraceTypeHelper>();
        if (validCandidates.isEmpty()) {
            File traceFile = new File(path);
            if (traceFile.isFile()) {
                return returned;
            }
            String errorMsg = NLS.bind((String)Messages.TmfOpenTraceHelper_NoTraceTypeMatch, (Object)path);
            throw new TmfTraceImportException(errorMsg);
        }
        if (validCandidates.size() != 1) {
            List<Pair<Integer, TraceTypeHelper>> reducedCandidates = TmfTraceType.reduce(validCandidates);
            if (reducedCandidates.isEmpty()) {
                throw new TmfTraceImportException("Error reducing trace type candidates");
            }
            if (reducedCandidates.size() == 1) {
                if (reducedCandidates.get(0).getFirst() > 0) {
                    returned.add(reducedCandidates.get(0).getSecond());
                }
            } else {
                for (Pair<Integer, TraceTypeHelper> candidatePair : reducedCandidates) {
                    if (candidatePair.getFirst() <= 0) continue;
                    returned.add(candidatePair.getSecond());
                }
            }
        } else if (validCandidates.first().getFirst() > 0) {
            returned.add(validCandidates.first().getSecond());
        }
        return returned;
    }

    private static List<Pair<Integer, TraceTypeHelper>> reduce(Collection<Pair<Integer, TraceTypeHelper>> candidates) {
        ArrayList<Pair<Integer, TraceTypeHelper>> retVal = new ArrayList<Pair<Integer, TraceTypeHelper>>();
        for (Pair<Integer, TraceTypeHelper> candidatePair : candidates) {
            TraceTypeHelper candidate = candidatePair.getSecond();
            if (!TmfTraceType.isUnique(candidate, candidates)) continue;
            retVal.add(candidatePair);
        }
        return retVal;
    }

    private static boolean isUnique(TraceTypeHelper trace, Collection<Pair<Integer, TraceTypeHelper>> set) {
        if (trace.getTraceClass().equals(CustomTxtTrace.class) || trace.getTraceClass().equals(CustomXmlTrace.class)) {
            return true;
        }
        ITmfTrace tmfTrace = trace.getTrace();
        int count = -1;
        for (Pair<Integer, TraceTypeHelper> child : set) {
            ITmfTrace traceCandidate = child.getSecond().getTrace();
            if (!tmfTrace.getClass().isInstance(traceCandidate)) continue;
            ++count;
        }
        return count == 0;
    }

    public static List<TraceTypeHelper> selectExperimentType(List<ITmfTrace> traces, String experimentTypeHint) {
        Comparator comparator = (o1, o2) -> {
            int res = ((Integer)o2.getFirst()).compareTo((Integer)o1.getFirst());
            if (res == 0) {
                res = ((TraceTypeHelper)o1.getSecond()).getName().compareTo(((TraceTypeHelper)o2.getSecond()).getName());
            }
            return res;
        };
        TreeSet<Pair<Integer, TraceTypeHelper>> validCandidates = new TreeSet<Pair<Integer, TraceTypeHelper>>(comparator);
        Iterable<TraceTypeHelper> traceTypeHelpers = TmfTraceType.getTraceTypeHelpers();
        for (TraceTypeHelper traceTypeHelper : traceTypeHelpers) {
            int confidence;
            if (!traceTypeHelper.isEnabled() || !traceTypeHelper.isExperimentType() || (confidence = traceTypeHelper.validateExperimentWithTraces(traces)) < 0) continue;
            if (traceTypeHelper.getTraceTypeId().equals(experimentTypeHint)) {
                return Collections.singletonList(traceTypeHelper);
            }
            Pair<Integer, TraceTypeHelper> element = new Pair<Integer, TraceTypeHelper>(confidence, traceTypeHelper);
            validCandidates.add(element);
        }
        ArrayList<TraceTypeHelper> returned = new ArrayList<TraceTypeHelper>();
        if (validCandidates.isEmpty()) {
            Activator.logInfo("No valid candidates were found, selecting generic TMF experiment type");
            returned.add(TmfTraceType.getTraceType(DEFAULT_EXPERIMENT_TYPE));
            return returned;
        }
        if (validCandidates.size() != 1) {
            List<Pair<Integer, TraceTypeHelper>> reducedCandidates = TmfTraceType.reduce(validCandidates);
            if (reducedCandidates.isEmpty()) {
                Activator.logInfo("Error reducing experiment type candidates, selecting generic TMF experiment type");
                returned.add(TmfTraceType.getTraceType(DEFAULT_EXPERIMENT_TYPE));
                return returned;
            }
            if (reducedCandidates.size() == 1) {
                if (reducedCandidates.get(0).getFirst() > 0) {
                    returned.add(reducedCandidates.get(0).getSecond());
                }
            } else {
                for (Pair<Integer, TraceTypeHelper> candidatePair : reducedCandidates) {
                    if (candidatePair.getFirst() <= 0) continue;
                    returned.add(candidatePair.getSecond());
                }
            }
        } else if (validCandidates.first().getFirst() > 0) {
            returned.add(validCandidates.first().getSecond());
        }
        return returned;
    }

    public static @Nullable TmfExperiment instantiateExperiment(@NonNull String typeID) throws CoreException {
        IConfigurationElement ce = TRACE_TYPE_ATTRIBUTES.get(typeID);
        if (ce == null) {
            return null;
        }
        return (TmfExperiment)ce.createExecutableExtension(EXPERIMENT_TYPE_ATTR);
    }

    public static @Nullable ITmfEvent instantiateEvent(@NonNull String traceTypeId) throws CoreException {
        IConfigurationElement ce;
        String id;
        CustomTraceDefinition def;
        int n;
        int n2;
        CustomTraceDefinition[] customTraceDefinitionArray;
        if (CustomTxtTrace.isCustomTraceTypeId(traceTypeId)) {
            customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
            n2 = customTraceDefinitionArray.length;
            n = 0;
            while (n < n2) {
                def = customTraceDefinitionArray[n];
                id = CustomTxtTrace.buildTraceTypeId(((CustomTxtTraceDefinition)def).categoryName, ((CustomTxtTraceDefinition)def).definitionName);
                if (traceTypeId.equals(id)) {
                    return new CustomTxtEvent((CustomTxtTraceDefinition)def);
                }
                ++n;
            }
        }
        if (CustomXmlTrace.isCustomTraceTypeId(traceTypeId)) {
            customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
            n2 = customTraceDefinitionArray.length;
            n = 0;
            while (n < n2) {
                def = customTraceDefinitionArray[n];
                id = CustomXmlTrace.buildTraceTypeId(((CustomXmlTraceDefinition)def).categoryName, ((CustomXmlTraceDefinition)def).definitionName);
                if (traceTypeId.equals(id)) {
                    return new CustomXmlEvent((CustomXmlTraceDefinition)def);
                }
                ++n;
            }
        }
        if ((ce = TRACE_TYPE_ATTRIBUTES.get(traceTypeId)) == null) {
            return null;
        }
        return (ITmfEvent)ce.createExecutableExtension(EVENT_TYPE_ATTR);
    }

    public static String checkAndUpdateTracePath(String path) {
        File file = new File(path);
        if (file.exists() && !file.isDirectory()) {
            File parent = file.getParentFile();
            String pathToUse = parent.getAbsolutePath();
            if (TmfTraceType.isDirectoryTrace(pathToUse)) {
                return pathToUse;
            }
            File grandParent = parent.getParentFile();
            if (grandParent != null && TmfTraceType.isDirectoryTrace(pathToUse = grandParent.getAbsolutePath())) {
                return pathToUse;
            }
        }
        return path;
    }

    public static enum TraceElementType {
        TRACE,
        EXPERIMENT;

    }
}

