/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.grammar.BalancedBracketSelectors;
import org.eclipse.tm4e.core.internal.grammar.dependencies.ScopeDependencyProcessor;
import org.eclipse.tm4e.core.internal.grammar.raw.IRawGrammar;
import org.eclipse.tm4e.core.internal.grammar.raw.RawGrammarReader;
import org.eclipse.tm4e.core.internal.registry.SyncRegistry;
import org.eclipse.tm4e.core.internal.theme.Theme;
import org.eclipse.tm4e.core.internal.theme.raw.RawThemeReader;
import org.eclipse.tm4e.core.internal.utils.MoreCollections;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.registry.IGrammarConfiguration;
import org.eclipse.tm4e.core.registry.IGrammarSource;
import org.eclipse.tm4e.core.registry.IRegistryOptions;
import org.eclipse.tm4e.core.registry.IThemeSource;

public final class Registry {
    private static final System.Logger LOGGER = System.getLogger(Registry.class.getName());
    private final IRegistryOptions _options;
    private final SyncRegistry _syncRegistry;
    private final Map<String, Boolean> _ensureGrammarCache = new HashMap<String, Boolean>();

    public Registry() {
        this(new IRegistryOptions(){});
    }

    public Registry(IRegistryOptions options) {
        this._options = options;
        this._syncRegistry = new SyncRegistry(Theme.createFromRawTheme(options.getTheme(), options.getColorMap()));
    }

    public void setTheme(IThemeSource source) throws TMException {
        try {
            this._syncRegistry.setTheme(Theme.createFromRawTheme(RawThemeReader.readTheme(source), this._options.getColorMap()));
        }
        catch (Exception ex) {
            throw new TMException("Loading theme from '" + source.getFilePath() + "' failed: " + ex.getMessage(), ex);
        }
    }

    public List<String> getColorMap() {
        return this._syncRegistry.getColorMap();
    }

    public @Nullable IGrammar loadGrammarWithEmbeddedLanguages(String initialScopeName, int initialLanguage, final Map<String, Integer> embeddedLanguages) {
        return this.loadGrammarWithConfiguration(initialScopeName, initialLanguage, new IGrammarConfiguration(){

            @Override
            public @Nullable Map<String, Integer> getEmbeddedLanguages() {
                return embeddedLanguages;
            }
        });
    }

    public @Nullable IGrammar loadGrammarWithConfiguration(String initialScopeName, int initialLanguage, IGrammarConfiguration configuration) {
        return this._loadGrammar(initialScopeName, initialLanguage, configuration.getEmbeddedLanguages(), configuration.getTokenTypes(), new BalancedBracketSelectors(MoreCollections.nullToEmpty(configuration.getBalancedBracketSelectors()), MoreCollections.nullToEmpty(configuration.getUnbalancedBracketSelectors())));
    }

    public @Nullable IGrammar loadGrammar(String initialScopeName) {
        return this._loadGrammar(initialScopeName, 0, null, null, null);
    }

    private @Nullable IGrammar _loadGrammar(String initialScopeName, int initialLanguage, @Nullable Map<String, Integer> embeddedLanguages, @Nullable Map<String, Integer> tokenTypes, @Nullable BalancedBracketSelectors balancedBracketSelectors) {
        ScopeDependencyProcessor dependencyProcessor = new ScopeDependencyProcessor(this._syncRegistry, initialScopeName);
        while (!dependencyProcessor.Q.isEmpty()) {
            dependencyProcessor.Q.forEach(request -> this._loadSingleGrammar(request.scopeName));
            dependencyProcessor.processQueue();
        }
        return this._grammarForScopeName(initialScopeName, initialLanguage, embeddedLanguages, tokenTypes, balancedBracketSelectors);
    }

    private void _loadSingleGrammar(String scopeName) {
        this._ensureGrammarCache.computeIfAbsent(scopeName, this::_doLoadSingleGrammar);
    }

    private boolean _doLoadSingleGrammar(String scopeName) {
        IGrammarSource grammarSource = this._options.getGrammarSource(scopeName);
        if (grammarSource == null) {
            LOGGER.log(System.Logger.Level.WARNING, "No grammar source for scope [{0}]", scopeName);
            return false;
        }
        try {
            IRawGrammar grammar = RawGrammarReader.readGrammar(grammarSource);
            this._syncRegistry.addGrammar(grammar, this._options.getInjections(scopeName));
        }
        catch (Exception ex) {
            LOGGER.log(System.Logger.Level.ERROR, "Loading grammar for scope [{0}] failed: {1}", scopeName, ex.getMessage(), ex);
            return false;
        }
        return true;
    }

    public IGrammar addGrammar(IGrammarSource source) throws TMException {
        return this.addGrammar(source, null, null, null);
    }

    public IGrammar addGrammar(IGrammarSource source, @Nullable List<String> injections, @Nullable Integer initialLanguage, @Nullable Map<String, Integer> embeddedLanguages) throws TMException {
        try {
            IRawGrammar rawGrammar = RawGrammarReader.readGrammar(source);
            this._syncRegistry.addGrammar(rawGrammar, injections == null || injections.isEmpty() ? this._options.getInjections(rawGrammar.getScopeName()) : injections);
            return NullSafetyHelper.castNonNull(this._grammarForScopeName(rawGrammar.getScopeName(), initialLanguage, embeddedLanguages, null, null));
        }
        catch (Exception ex) {
            throw new TMException("Loading grammar from '" + source.getFilePath() + "' failed: " + ex.getMessage(), ex);
        }
    }

    public @Nullable IGrammar grammarForScopeName(String scopeName) {
        return this._grammarForScopeName(scopeName, null, null, null, null);
    }

    private @Nullable IGrammar _grammarForScopeName(String scopeName, @Nullable Integer initialLanguage, @Nullable Map<String, Integer> embeddedLanguages, @Nullable Map<String, Integer> tokenTypes, @Nullable BalancedBracketSelectors balancedBracketSelectors) {
        return this._syncRegistry.grammarForScopeName(scopeName, initialLanguage == null ? 0 : initialLanguage, embeddedLanguages, tokenTypes, balancedBracketSelectors);
    }
}

