/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.ui.internal.preferences.PreferenceHelper;
import org.eclipse.tm4e.ui.internal.themes.AbstractThemeManager;
import org.eclipse.tm4e.ui.internal.utils.PreferenceUtils;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.Theme;
import org.eclipse.tm4e.ui.themes.ThemeAssociation;
import org.osgi.service.prefs.BackingStoreException;

public final class ThemeManager
extends AbstractThemeManager {
    private static final String EXTENSION_THEMES = "themes";
    private static final String THEME_ELT = "theme";
    private static final String THEME_ASSOCIATION_ELT = "themeAssociation";
    private static @Nullable ThemeManager INSTANCE;

    public static ThemeManager getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = ThemeManager.createInstance();
        return INSTANCE;
    }

    private static synchronized ThemeManager createInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        ThemeManager manager = new ThemeManager();
        manager.load();
        return manager;
    }

    private ThemeManager() {
    }

    private void load() {
        this.loadThemesFromExtensionPoints();
        this.loadThemesFromPreferences();
    }

    private void loadThemesFromExtensionPoints() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tm4e.ui", EXTENSION_THEMES);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            switch (name = configElement.getName()) {
                case "theme": {
                    super.registerTheme(new Theme(configElement));
                    break;
                }
                case "themeAssociation": {
                    super.registerThemeAssociation(new ThemeAssociation(configElement));
                }
            }
            ++n2;
        }
    }

    private void loadThemesFromPreferences() {
        int n;
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.ui");
        String json = prefs.get("org.eclipse.tm4e.ui.themes", null);
        if (json != null) {
            JsonObject[] jsonObjectArray = (JsonObject[])new Gson().fromJson(json, JsonObject[].class);
            n = jsonObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                JsonObject element = jsonObjectArray[n2];
                String name = element.get("id").getAsString();
                super.registerTheme(new Theme(name, element.get("path").getAsString(), name, element.get("dark").getAsBoolean(), false));
                ++n2;
            }
        }
        if ((json = prefs.get("org.eclipse.tm4e.ui.themeAssociations", null)) != null) {
            IThemeAssociation[] themeAssociations;
            IThemeAssociation[] iThemeAssociationArray = themeAssociations = PreferenceHelper.loadThemeAssociations(json);
            int n3 = themeAssociations.length;
            n = 0;
            while (n < n3) {
                IThemeAssociation association = iThemeAssociationArray[n];
                super.registerThemeAssociation(association);
                ++n;
            }
        }
    }

    @Override
    public void save() throws BackingStoreException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.ui");
        prefs.put("org.eclipse.tm4e.ui.themes", Arrays.stream(this.getThemes()).filter(t -> t.getPluginId() == null).map(theme -> {
            JsonObject json = new JsonObject();
            json.addProperty("id", theme.getId());
            json.addProperty("path", theme.getPath());
            json.addProperty("dark", Boolean.valueOf(theme.isDark()));
            return json;
        }).collect(JsonArray::new, (array, object) -> array.add((JsonElement)object), (r, r1) -> {}).toString());
        String json = PreferenceHelper.toJsonThemeAssociations(Arrays.stream(this.getAllThemeAssociations()).filter(t -> t.getPluginId() == null).collect(Collectors.toList()));
        prefs.put("org.eclipse.tm4e.ui.themeAssociations", json);
        prefs.flush();
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener themeChangeListener) {
        IEclipsePreferences preferences = PreferenceUtils.getE4PreferenceStore();
        if (preferences != null) {
            preferences.addPreferenceChangeListener(themeChangeListener);
        }
        if ((preferences = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.ui")) != null) {
            preferences.addPreferenceChangeListener(themeChangeListener);
        }
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener themeChangeListener) {
        IEclipsePreferences preferences = PreferenceUtils.getE4PreferenceStore();
        if (preferences != null) {
            preferences.removePreferenceChangeListener(themeChangeListener);
        }
        if ((preferences = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.ui")) != null) {
            preferences.removePreferenceChangeListener(themeChangeListener);
        }
    }
}

