/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design;

import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.design.StepBuilder;
import org.polarsys.time4sys.marte.gqam.ArrivalPattern;
import org.polarsys.time4sys.marte.gqam.BehaviorScenario;
import org.polarsys.time4sys.marte.gqam.PeriodicPattern;
import org.polarsys.time4sys.marte.gqam.Step;
import org.polarsys.time4sys.marte.gqam.WorkloadEvent;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;

public class WorkloadEventBuilder {
    private DesignBuilder design;
    private WorkloadEvent evt;

    public WorkloadEventBuilder(DesignBuilder designBuilder, WorkloadEvent taskActivation) {
        assert (taskActivation != null);
        this.design = designBuilder;
        this.evt = taskActivation;
    }

    public WorkloadEventBuilder forStep(StepBuilder firstStep) {
        return this.forStep(firstStep.build());
    }

    public WorkloadEventBuilder forStep(Step step) {
        this.evt.setEffect((BehaviorScenario)step);
        String stepName = step.getName();
        if (stepName != null) {
            this.evt.setName(String.valueOf(stepName) + " activator");
        }
        return this;
    }

    public WorkloadEvent build() {
        return this.evt;
    }

    public void ofOffset(String value) {
        ArrivalPattern ptrn = this.evt.getPattern();
        if (ptrn instanceof PeriodicPattern) {
            PeriodicPattern p = (PeriodicPattern)ptrn;
            p.setPhase(NfpFactory.eINSTANCE.createDurationFromString(value));
        }
    }

    public Duration getOffset() {
        ArrivalPattern ptrn = this.evt.getPattern();
        if (ptrn instanceof PeriodicPattern) {
            PeriodicPattern p = (PeriodicPattern)ptrn;
            return p.getPhase();
        }
        throw new IllegalStateException("Pattern is not period: " + ptrn.getClass().getName());
    }

    public void ofJitter(String value) {
        ArrivalPattern ptrn = this.evt.getPattern();
        if (ptrn instanceof PeriodicPattern) {
            PeriodicPattern p = (PeriodicPattern)ptrn;
            p.setJitter(NfpFactory.eINSTANCE.createDurationFromString(value));
        }
    }
}

