/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.interpreter.api;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class VariableManager
implements IVariableManager {
    private IVariableManager parent;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private List<IVariableManager> children = new ArrayList<IVariableManager>();

    public VariableManager() {
    }

    public VariableManager(IVariableManager parent) {
        this.parent = parent;
    }

    @Override
    public Object put(String name, Object value) {
        Object previous = this.variables.put(name, value);
        return previous;
    }

    @Override
    public Map<String, Object> getVariables() {
        if (this.parent != null) {
            Map<String, Object> parentVariables = this.parent.getVariables();
            parentVariables.putAll(this.variables);
            return parentVariables;
        }
        return Maps.newHashMap(this.variables);
    }

    @Override
    public IVariableManager createChild() {
        VariableManager variableManager = new VariableManager(this);
        this.children.add(variableManager);
        return variableManager;
    }

    @Override
    public void clear() {
        this.variables.clear();
        for (IVariableManager variableManager : this.children) {
            variableManager.clear();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> var : this.getVariables().entrySet()) {
            String name = var.getKey();
            Object value = var.getValue();
            boolean local = this.variables.containsKey(name);
            sb.append(name).append(" = ").append(value);
            if (!local) {
                sb.append(" [inherited]");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

