/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.nfp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DiscreteDistributionKind implements Enumerator
{
    UNDEF(0, "Undef", "Undef"),
    RANDOM(1, "Random", "Random"),
    CYCLIC(2, "Cyclic", "cyclic");

    public static final int UNDEF_VALUE = 0;
    public static final int RANDOM_VALUE = 1;
    public static final int CYCLIC_VALUE = 2;
    private static final DiscreteDistributionKind[] VALUES_ARRAY;
    public static final List<DiscreteDistributionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DiscreteDistributionKind[]{UNDEF, RANDOM, CYCLIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DiscreteDistributionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DiscreteDistributionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DiscreteDistributionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DiscreteDistributionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DiscreteDistributionKind get(int value) {
        switch (value) {
            case 0: {
                return UNDEF;
            }
            case 1: {
                return RANDOM;
            }
            case 2: {
                return CYCLIC;
            }
        }
        return null;
    }

    private DiscreteDistributionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

