/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.gqam;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LaxityKind implements Enumerator
{
    UNDEF(0, "undef", "undef"),
    HARD(1, "hard", "hard"),
    SOFT(2, "soft", "soft"),
    OTHER(3, "other", "");

    public static final int UNDEF_VALUE = 0;
    public static final int HARD_VALUE = 1;
    public static final int SOFT_VALUE = 2;
    public static final int OTHER_VALUE = 3;
    private static final LaxityKind[] VALUES_ARRAY;
    public static final List<LaxityKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LaxityKind[]{UNDEF, HARD, SOFT, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LaxityKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LaxityKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LaxityKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LaxityKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LaxityKind get(int value) {
        switch (value) {
            case 0: {
                return UNDEF;
            }
            case 1: {
                return HARD;
            }
            case 2: {
                return SOFT;
            }
            case 3: {
                return OTHER;
            }
        }
        return null;
    }

    private LaxityKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

