/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.api.query;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.LineContainer;

public class DTableQuery {
    private final DTable table;

    public DTableQuery(DTable table) {
        Preconditions.checkNotNull((Object)table);
        this.table = table;
    }

    public List<DCell> getCells() {
        ArrayList<DCell> cells = new ArrayList<DCell>();
        for (DLine line : this.getAllLines()) {
            cells.addAll((Collection<DCell>)line.getCells());
        }
        return cells;
    }

    public Option<DCell> getFirstCell() {
        List<DCell> cells = this.getCells();
        if (cells.isEmpty()) {
            return Options.newNone();
        }
        return Options.newSome((Object)cells.get(0));
    }

    public List<DLine> getAllLines() {
        return this.getAllLines(this.table);
    }

    protected List<DLine> getAllLines(LineContainer lineContainer) {
        ArrayList<DLine> allLines = new ArrayList<DLine>();
        for (DLine dLine : lineContainer.getLines()) {
            allLines.add(dLine);
            allLines.addAll(this.getAllLines(dLine));
        }
        return allLines;
    }
}

