/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.edit.internal.generator;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;

public final class GapPatternGenerator {
    private GapPatternGenerator() {
    }

    public static void main(String[] args) {
        String userDir = System.getProperty("user.dir");
        Path siriusPropertiesEditProjectPath = Paths.get(userDir, new String[0]);
        Path siriusPropertiesProjectPath = siriusPropertiesEditProjectPath.getParent().resolve("org.eclipse.sirius.properties");
        Path ecoreModel = siriusPropertiesProjectPath.resolve("model/properties.ecore");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        URI uri = URI.createFileURI((String)ecoreModel.toAbsolutePath().toString());
        Path outputFolderPath = siriusPropertiesEditProjectPath.resolve("src-spec/org/eclipse/sirius/properties/provider");
        Resource resource = resourceSet.getResource(uri, true);
        if (resource != null && resource.getContents().size() == 1 && resource.getContents().get(0) instanceof EPackage) {
            EPackage ePackage = (EPackage)resource.getContents().get(0);
            GapPatternGenerator.generateAdapterFactory(outputFolderPath, ePackage);
            GapPatternGenerator.generateDescriptionChildCreationExtender(outputFolderPath, ePackage);
            GapPatternGenerator.generateValidationChildCreationExtender(outputFolderPath, ePackage);
            EList eClassifiers = ePackage.getEClassifiers();
            for (EClassifier eClassifier : eClassifiers) {
                if (!(eClassifier instanceof EClass)) continue;
                GapPatternGenerator.generateItemProvider(outputFolderPath, (EClass)eClassifier);
            }
        }
    }

    private static StringBuilder appendCopyright(StringBuilder builder) {
        builder.append("/**").append(System.lineSeparator());
        builder.append(" * Copyright (c) 2017 Obeo.").append(System.lineSeparator());
        builder.append(" * All rights reserved. This program and the accompanying materials").append(System.lineSeparator());
        builder.append(" * are made available under the terms of the Eclipse Public License v1.0").append(System.lineSeparator());
        builder.append(" * which accompanies this distribution, and is available at").append(System.lineSeparator());
        builder.append(" * http://www.eclipse.org/legal/epl-v10.html").append(System.lineSeparator());
        builder.append(" *").append(System.lineSeparator());
        builder.append(" * Contributors:").append(System.lineSeparator());
        builder.append(" *    Obeo - initial API and implementation").append(System.lineSeparator());
        builder.append(" *").append(System.lineSeparator());
        builder.append(" */").append(System.lineSeparator());
        return builder;
    }

    private static String toUpperFirst(String word) {
        return String.valueOf(word.substring(0, 1).toUpperCase()) + word.substring(1);
    }

    private static String toLowerFirst(String word) {
        return String.valueOf(word.substring(0, 1).toLowerCase()) + word.substring(1);
    }

    private static void writeSourceFile(Path outputFilePath, StringBuilder builder, boolean force) {
        File parentFolder = outputFilePath.toFile().getParentFile();
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        if (!outputFilePath.toFile().exists() || force) {
            try {
                Files.write(outputFilePath, builder.toString().getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void generateAdapterFactory(Path outputFolderPath, EPackage ePackage) {
        StringBuilder builder = GapPatternGenerator.appendCopyright(new StringBuilder());
        builder.append("package org.eclipse.sirius.properties.provider;").append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("import org.eclipse.emf.common.notify.Adapter;").append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("/**").append(System.lineSeparator());
        builder.append(" * Subclass used to not have to modify the generated code.").append(System.lineSeparator());
        builder.append(" *").append(System.lineSeparator());
        builder.append(" * @author ").append(System.getProperty("user.name")).append(System.lineSeparator());
        builder.append(" */").append(System.lineSeparator());
        builder.append("public class PropertiesItemProviderAdapterFactorySpec extends PropertiesItemProviderAdapterFactory {").append(System.lineSeparator());
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass) || ((EClass)eClassifier).isAbstract() || ((EClass)eClassifier).isInterface()) continue;
            builder.append(System.lineSeparator());
            builder.append("    @Override").append(System.lineSeparator());
            builder.append("    public Adapter create" + GapPatternGenerator.toUpperFirst(eClassifier.getName()) + "Adapter() {").append(System.lineSeparator());
            builder.append("        if (" + GapPatternGenerator.toLowerFirst(eClassifier.getName()) + "ItemProvider == null) {").append(System.lineSeparator());
            builder.append("            " + GapPatternGenerator.toLowerFirst(eClassifier.getName()) + "ItemProvider = new " + GapPatternGenerator.toUpperFirst(eClassifier.getName()) + "ItemProviderSpec(this);").append(System.lineSeparator());
            builder.append("        }").append(System.lineSeparator());
            builder.append(System.lineSeparator());
            builder.append("        return " + GapPatternGenerator.toLowerFirst(eClassifier.getName()) + "ItemProvider;").append(System.lineSeparator());
            builder.append("    }").append(System.lineSeparator());
        }
        builder.append("}").append(System.lineSeparator());
        String className = String.valueOf(GapPatternGenerator.toUpperFirst(ePackage.getName())) + "ItemProviderAdapterFactorySpec.java";
        Path outputFilePath = outputFolderPath.resolve(className);
        GapPatternGenerator.writeSourceFile(outputFilePath, builder, true);
    }

    private static void generateDescriptionChildCreationExtender(Path outputFolderPath, EPackage ePackage) {
        StringBuilder builder = GapPatternGenerator.appendCopyright(new StringBuilder());
        builder.append("package org.eclipse.sirius.properties.provider;").append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("import org.eclipse.sirius.properties.provider.PropertiesItemProviderAdapterFactory.DescriptionChildCreationExtender;").append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("/**").append(System.lineSeparator());
        builder.append(" * Subclass used to not have to modify the generated code.").append(System.lineSeparator());
        builder.append(" *").append(System.lineSeparator());
        builder.append(" * @author ").append(System.getProperty("user.name")).append(System.lineSeparator());
        builder.append(" */").append(System.lineSeparator());
        builder.append("public class DescriptionChildCreationExtenderSpec extends DescriptionChildCreationExtender {").append(System.lineSeparator());
        builder.append("}").append(System.lineSeparator());
        String className = "DescriptionChildCreationExtenderSpec.java";
        Path outputFilePath = outputFolderPath.resolve(className);
        GapPatternGenerator.writeSourceFile(outputFilePath, builder, false);
    }

    private static void generateValidationChildCreationExtender(Path outputFolderPath, EPackage ePackage) {
        StringBuilder builder = GapPatternGenerator.appendCopyright(new StringBuilder());
        builder.append("package org.eclipse.sirius.properties.provider;").append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("import org.eclipse.sirius.properties.provider.PropertiesItemProviderAdapterFactory.ValidationChildCreationExtender;").append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("/**").append(System.lineSeparator());
        builder.append(" * Subclass used to not have to modify the generated code.").append(System.lineSeparator());
        builder.append(" *").append(System.lineSeparator());
        builder.append(" * @author ").append(System.getProperty("user.name")).append(System.lineSeparator());
        builder.append(" */").append(System.lineSeparator());
        builder.append("public class ValidationChildCreationExtenderSpec extends ValidationChildCreationExtender {").append(System.lineSeparator());
        builder.append("}").append(System.lineSeparator());
        String className = "ValidationChildCreationExtenderSpec.java";
        Path outputFilePath = outputFolderPath.resolve(className);
        GapPatternGenerator.writeSourceFile(outputFilePath, builder, false);
    }

    private static void generateItemProvider(Path outputFolderPath, EClass eClass) {
        StringBuilder builder = GapPatternGenerator.appendCopyright(new StringBuilder());
        builder.append("package org.eclipse.sirius.properties.provider;").append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("import org.eclipse.emf.common.notify.AdapterFactory;").append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("/**").append(System.lineSeparator());
        builder.append(" * Subclass used to not have to modify the generated code.").append(System.lineSeparator());
        builder.append(" *").append(System.lineSeparator());
        builder.append(" * @author sbegaudeau").append(System.lineSeparator());
        builder.append(" */").append(System.lineSeparator());
        builder.append("public class " + GapPatternGenerator.toUpperFirst(eClass.getName()) + "ItemProviderSpec extends " + GapPatternGenerator.toUpperFirst(eClass.getName()) + "ItemProvider {").append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("    /**").append(System.lineSeparator());
        builder.append("     * The constructor.").append(System.lineSeparator());
        builder.append("     *").append(System.lineSeparator());
        builder.append("     * @param adapterFactory").append(System.lineSeparator());
        builder.append("     *            The adapter factory").append(System.lineSeparator());
        builder.append("     */").append(System.lineSeparator());
        builder.append("    public " + GapPatternGenerator.toUpperFirst(eClass.getName()) + "ItemProviderSpec(AdapterFactory adapterFactory) {").append(System.lineSeparator());
        builder.append("        super(adapterFactory);").append(System.lineSeparator());
        builder.append("    }").append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("}").append(System.lineSeparator());
        String className = String.valueOf(GapPatternGenerator.toUpperFirst(eClass.getName())) + "ItemProviderSpec.java";
        Path outputFilePath = outputFolderPath.resolve(className);
        GapPatternGenerator.writeSourceFile(outputFilePath, builder, false);
    }
}

