/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.core.query.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.amalgam.explorer.contextual.core.ext.AbstractExtensionPointManager;
import org.eclipse.amalgam.explorer.contextual.core.filter.CandidateElementFilterManager;
import org.eclipse.amalgam.explorer.contextual.core.query.ICustomQueryExecutionManager;
import org.eclipse.amalgam.explorer.contextual.core.query.impl.QueryComputeCommand;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public final class QueryExecutionManager
extends AbstractExtensionPointManager {
    private static final String _CUSTOM_QUERY_EXEC_MANAGER__CONF_NAME = "customQueryExecutionManager";
    private static final String _QUERY_CLASS__ATTR_NAME = "queryClass";
    private static final String _QUERY_CUSTOM_EXECUTION_MANAGER_CLASS__ATTR_NAME = "customExecutionManager";
    private static QueryExecutionManager _instance = null;
    private Map<String, ICustomQueryExecutionManager> _availableCustomQueryExecutionManager = new HashMap<String, ICustomQueryExecutionManager>();

    public static QueryExecutionManager getInstance() {
        if (_instance == null) {
            _instance = new QueryExecutionManager();
        }
        return _instance;
    }

    public QueryExecutionManager() {
        this.initRegistry();
    }

    public List<Object> executeQueryWithResult(Object query_p, Object currentElement_p) {
        List<Object> result = Collections.emptyList();
        ICustomQueryExecutionManager customQueryExecution = this.getCustomQueryExecution(query_p);
        if (customQueryExecution != null) {
            List<Object> executeWithResult = customQueryExecution.executeWithResult(query_p, currentElement_p);
            result = new ArrayList<Object>(executeWithResult);
        } else {
            QueryComputeCommand queryComputeCommand = new QueryComputeCommand(currentElement_p, query_p);
            try {
                this.defaultQueryExecution((RunnableWithResult)queryComputeCommand, currentElement_p);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            List queryResult = (List)queryComputeCommand.getResult();
            if (queryResult != null) {
                result = new ArrayList<Object>(queryResult);
            }
        }
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next == null) {
                iterator.remove();
                continue;
            }
            if (CandidateElementFilterManager.accept(next)) continue;
            iterator.remove();
        }
        return result;
    }

    private ICustomQueryExecutionManager getCustomQueryExecution(Object query_p) {
        String queryClassName = query_p.getClass().getName();
        ICustomQueryExecutionManager result = null;
        result = this._availableCustomQueryExecutionManager.get(queryClassName);
        if (result == null) {
            result = this.checkClassIftypeOf(query_p.getClass());
        }
        return result;
    }

    private ICustomQueryExecutionManager checkClassIftypeOf(Class clazz) {
        ICustomQueryExecutionManager result = null;
        Class superclass = clazz.getSuperclass();
        if (superclass != null && (result = this._availableCustomQueryExecutionManager.get(superclass.getName())) == null) {
            result = this.checkClassIftypeOf(superclass);
        }
        if (result == null) {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = clazz.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iInterface = classArray[n2];
                result = this._availableCustomQueryExecutionManager.get(iInterface.getName());
                if (result != null) break;
                result = this.checkClassIftypeOf(iInterface);
                ++n2;
            }
        }
        return result;
    }

    private void initRegistry() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = QueryExecutionManager.getConfigurationElementsFor("org.eclipse.amalgam.explorer.contextual.core", _CUSTOM_QUERY_EXEC_MANAGER__CONF_NAME);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String queryClassFQN = "";
            ICustomQueryExecutionManager execManager = null;
            queryClassFQN = iConfigurationElement.getAttribute(_QUERY_CLASS__ATTR_NAME);
            execManager = QueryExecutionManager.createTypedInstance(iConfigurationElement, _QUERY_CUSTOM_EXECUTION_MANAGER_CLASS__ATTR_NAME, ICustomQueryExecutionManager.class);
            this._availableCustomQueryExecutionManager.put(queryClassFQN, execManager);
            ++n2;
        }
    }

    private void defaultQueryExecution(RunnableWithResult runnable_p, Object currentElement_p) throws InterruptedException {
        if (currentElement_p instanceof EObject) {
            EObject e_currentElement_p = (EObject)currentElement_p;
            Resource eResource = e_currentElement_p.eResource();
            if (eResource == null) {
                return;
            }
            ResourceSet resourceSet = eResource.getResourceSet();
            if (resourceSet == null) {
                return;
            }
            TransactionalEditingDomain editingDomain_p = TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain(resourceSet);
            if (editingDomain_p != null) {
                if (editingDomain_p != null) {
                    editingDomain_p.runExclusive((Runnable)runnable_p);
                }
            } else {
                runnable_p.run();
            }
        }
    }
}

