/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.EditorActionBarContributor;

public class ShowingModeSwitchingAction
extends DiagramAction {
    private static final ImageDescriptor ACTIVATE_SHOW_HIDE_MODE_IMAGE_DESCRIPTOR = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/showingMode_activate.gif");
    private DDiagram ddiagram;

    public ShowingModeSwitchingAction(IWorkbenchPage workbenchPage, DDiagram editorDiagram) {
        super(workbenchPage);
        this.setId("switchShowingMode");
        this.ddiagram = editorDiagram;
        this.setImageDescriptor(ACTIVATE_SHOW_HIDE_MODE_IMAGE_DESCRIPTOR);
        this.setTextAndStatusAccordingToShowingMode();
        this.setChecked(this.ddiagram.isIsInShowingMode());
    }

    private void setTextAndStatusAccordingToShowingMode() {
        if (this.ddiagram != null && this.ddiagram.isIsInShowingMode()) {
            this.setText(Messages.ShowingModeSwitchingAction_deactivate);
            this.setChecked(true);
        } else {
            this.setText(Messages.ShowingModeSwitchingAction_activate);
            this.setChecked(false);
        }
        IEditorPart activeEditor = EclipseUIUtil.getActiveEditor();
        if (activeEditor != null) {
            IEditorSite site = (IEditorSite)activeEditor.getSite();
            EditorActionBarContributor actionBarContributor = null;
            IStatusLineManager statusLineManager = null;
            if (site != null && site.getActionBarContributor() instanceof EditorActionBarContributor) {
                actionBarContributor = (EditorActionBarContributor)site.getActionBarContributor();
            }
            if (actionBarContributor != null && actionBarContributor.getActionBars() != null) {
                statusLineManager = actionBarContributor.getActionBars().getStatusLineManager();
            }
            if (statusLineManager != null) {
                if (this.ddiagram != null && this.ddiagram.isIsInShowingMode()) {
                    String statusMessage = Messages.ShowingModeSwitchingAction_statusOn;
                    statusLineManager.setMessage(DiagramUIPlugin.getPlugin().getImage(ACTIVATE_SHOW_HIDE_MODE_IMAGE_DESCRIPTOR), statusMessage);
                } else {
                    statusLineManager.setMessage("");
                }
            }
        }
    }

    public int getStyle() {
        return 2;
    }

    protected boolean isSelectionListener() {
        return false;
    }

    protected Command getCommand() {
        IDDiagramEditPart diagramEP;
        Object nextObject;
        UnexecutableCommand returnedCommand = UnexecutableCommand.INSTANCE;
        List selectedObjects = this.getSelectedObjects();
        if (!selectedObjects.isEmpty() && (nextObject = selectedObjects.iterator().next()) instanceof IDDiagramEditPart && (diagramEP = (IDDiagramEditPart)nextObject).getModel() instanceof Diagram && ((Diagram)diagramEP.getModel()).getElement() instanceof DDiagram) {
            Diagram diagramGMF = (Diagram)diagramEP.getModel();
            returnedCommand = this.switchShowingModeCommand((DDiagram)diagramGMF.getElement());
        }
        return returnedCommand;
    }

    private Command switchShowingModeCommand(DDiagram diagram) {
        UnexecutableCommand returnedCommand = UnexecutableCommand.INSTANCE;
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
        if (editingDomain != null) {
            String commandLabel = diagram.isIsInShowingMode() ? Messages.SetShowingModeCommandAndUpdateActionImage_deactivateLabel : Messages.SetShowingModeCommandAndUpdateActionImage_activateLabel;
            returnedCommand = new ICommandProxy((ICommand)new ShowingModeSwitch(editingDomain, diagram, commandLabel));
        }
        return returnedCommand;
    }

    public void dispose() {
        this.ddiagram = null;
        super.dispose();
    }

    protected Request createTargetRequest() {
        return null;
    }

    private class ShowingModeSwitch
    extends AbstractTransactionalCommand {
        private DDiagram diagram;

        ShowingModeSwitch(TransactionalEditingDomain domain, DDiagram diagram, String label) {
            super(domain, label, null);
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.diagram.setIsInShowingMode(!this.diagram.isIsInShowingMode());
            ShowingModeSwitchingAction.this.setTextAndStatusAccordingToShowingMode();
            return CommandResult.newOKCommandResult();
        }
    }
}

