/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.activity.explorer.activity;

import java.util.Collection;
import org.eclipse.amalgam.explorer.activity.ui.api.hyperlinkadapter.AbstractNewDiagramHyperlinkAdapter;
import org.eclipse.amalgam.explorer.activity.ui.api.manager.ActivityExplorerManager;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.selection.EObjectSelectionWizard;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.tools.api.ui.RefreshEditorsPrecommitListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.polarsys.time4sys.design.DesignFactory;
import org.polarsys.time4sys.design.DesignModel;
import org.polarsys.time4sys.model.time4sys.Project;

public class AnalysisActivity
extends AbstractNewDiagramHyperlinkAdapter {
    public AnalysisActivity() {
        super(ActivityExplorerManager.INSTANCE.getRootSemanticModel());
    }

    public void linkActivated(final HyperlinkEvent event) {
        final Session session = ActivityExplorerManager.INSTANCE.getSession();
        RefreshEditorsPrecommitListener repl = session.getRefreshEditorsListener();
        repl.notify(10);
        repl.notify(11);
        EObject root = ActivityExplorerManager.INSTANCE.getRootSemanticModel();
        if (root instanceof Project) {
            final Project rootProject = (Project)root;
            if (rootProject.getDerivations().size() > 0) {
                EObjectSelectionWizard wizard = new EObjectSelectionWizard("Create a Design diagram", "Select the transformed design model", null, (Collection)rootProject.getDerivations(), DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory());
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    this.linkPressed(event, wizard.getSelectedEObject(), session);
                }
            } else {
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)rootProject);
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        DesignModel designModel = DesignFactory.eINSTANCE.createDesignModel();
                        rootProject.getDerivations().add((Object)designModel);
                        AnalysisActivity.this.linkPressed(event, (EObject)designModel, session);
                    }
                });
            }
        }
    }

    public String getRepresentationName() {
        return "Transformed Design";
    }
}

