/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design.posix;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.time4sys.builder.design.Annotations;
import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.design.TaskBuilder;
import org.polarsys.time4sys.marte.grm.FixedPriorityParameters;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.grm.GrmPackage;
import org.polarsys.time4sys.marte.grm.PeriodicServerParameters;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.srm.SoftwareSchedulableResource;

public class PosixSporadicServerBuilder
extends TaskBuilder {
    public static final String POSIX_URL = "http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.posix";
    private static final EClass PSS_PARAM_ECLASS = GrmPackage.eINSTANCE.getPeriodicServerParameters();
    public static final String ORDER_ATTR = "pss_order";

    public static PosixSporadicServerBuilder aPSS() {
        return new PosixSporadicServerBuilder();
    }

    public static PosixSporadicServerBuilder as(TaskBuilder task) {
        return new PosixSporadicServerBuilder(task);
    }

    public static PosixSporadicServerBuilder as(SoftwareSchedulableResource task) {
        DesignBuilder db = DesignBuilder.containing((EObject)task);
        return new PosixSporadicServerBuilder(db, task);
    }

    public static boolean hasPSSOrder(SoftwareSchedulableResource aTask) {
        TaskBuilder taskBuilder = new TaskBuilder(null, aTask);
        if (taskBuilder.hasAnnotation(POSIX_URL)) {
            String orderValue = (String)taskBuilder.annotate(POSIX_URL).getDetails().get((Object)ORDER_ATTR);
            return orderValue != null;
        }
        return false;
    }

    public static boolean isInstance(SoftwareSchedulableResource task) {
        return Annotations.hasAnnotation((EModelElement)task, POSIX_URL);
    }

    public PosixSporadicServerBuilder() {
        this(null, null, PSS_PARAM_ECLASS);
    }

    public PosixSporadicServerBuilder(DesignBuilder designBuilder, SoftwareSchedulableResource raw) {
        this(designBuilder, raw, PSS_PARAM_ECLASS);
    }

    protected PosixSporadicServerBuilder(DesignBuilder designBuilder, SoftwareSchedulableResource raw, EClass clazz) {
        super(designBuilder, raw, clazz);
        this.annotate(POSIX_URL);
    }

    public PosixSporadicServerBuilder(TaskBuilder task) {
        this(task.design(), task.build(), PSS_PARAM_ECLASS);
    }

    @Override
    public PosixSporadicServerBuilder called(String value) {
        super.called(value);
        return this;
    }

    @Override
    public PosixSporadicServerBuilder ofWCET(String value) {
        super.ofWCET(value);
        return this;
    }

    @Override
    public PosixSporadicServerBuilder ofBCET(String value) {
        super.ofBCET(value);
        return this;
    }

    public PosixSporadicServerBuilder ofInitialBudget(String timeBudget) {
        return this.ofInitialBudget(NfpFactory.eINSTANCE.createDurationFromString(timeBudget));
    }

    public PosixSporadicServerBuilder ofInitialBudget(Duration timeBudget) {
        PeriodicServerParameters schedParam = this.getPSSSchedParams(true);
        schedParam.setInitialBudget(timeBudget);
        return this;
    }

    @Override
    public PosixSporadicServerBuilder ofPriority(int urgency) {
        super.ofPriority(urgency);
        return this;
    }

    @Override
    public PosixSporadicServerBuilder ofPeriod(String value) {
        super.ofPeriod(value);
        return this;
    }

    @Override
    public PosixSporadicServerBuilder ofDeadline(String value) {
        super.ofDeadline(value);
        return this;
    }

    public PosixSporadicServerBuilder ofBackgroundPriority(int urgency) {
        PeriodicServerParameters schedParam = (PeriodicServerParameters)this.getSchedParams("FixedPriority", this.fpParamEClass);
        schedParam.setBackgroundPriority(urgency);
        return this;
    }

    public int getBackgroundPriority() {
        PeriodicServerParameters schedParam = (PeriodicServerParameters)this.getSchedParams("FixedPriority", this.fpParamEClass);
        return schedParam.getBackgroundPriority();
    }

    @Override
    public PosixSporadicServerBuilder withSingleActivation() {
        super.withSingleActivation();
        return this;
    }

    public PosixSporadicServerBuilder withOrder(int order) {
        this.annotate(POSIX_URL).getDetails().put((Object)ORDER_ATTR, (Object)Integer.toString(order));
        return this;
    }

    public int getOrder() {
        String strVal = (String)this.annotate(POSIX_URL).getDetails().get((Object)ORDER_ATTR);
        return Integer.parseInt(strVal);
    }

    public boolean hasOrder() {
        return this.annotate(POSIX_URL).getDetails().get((Object)ORDER_ATTR) != null;
    }

    public PosixSporadicServerBuilder unsetOrder() {
        this.unsetAnnotationAttr(POSIX_URL, ORDER_ATTR);
        return this;
    }

    public PeriodicServerParameters getPSSSchedParams(boolean buildIfNone) {
        return (PeriodicServerParameters)this.getSchedParams("FixedPriority", buildIfNone ? this.fpParamEClass : null);
    }

    @Override
    public SoftwareSchedulableResource build() {
        FixedPriorityParameters schedParam = this.getFPSchedParams(false);
        if (schedParam != null && !(schedParam instanceof PeriodicServerParameters)) {
            PeriodicServerParameters migratedParams = GrmFactory.eINSTANCE.createPeriodicServerParameters(schedParam);
            this.task.getSchedParams().remove((Object)schedParam);
            this.task.getSchedParams().add((Object)migratedParams);
        }
        return super.build();
    }

    public Duration getInitialBudget() {
        PeriodicServerParameters schedParam = this.getPSSSchedParams(true);
        return schedParam.getInitialBudget();
    }

    public void setNotAPSS() {
        Annotations.removeAnnotation((EModelElement)this.build(), POSIX_URL);
    }
}

