/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida.registry.monitoring;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.componentization.ViewpointResourceHandler;
import org.eclipse.sirius.business.internal.movida.registry.monitoring.AbstractViewpointResourceMonitor;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class PluginMonitor
extends AbstractViewpointResourceMonitor {
    public static final String VSM_REGISTRATION_EXTENSION_POINT = "org.eclipse.sirius.viewpointSpecificationModel";
    private final IExtensionRegistry extensionRegistry;
    private final ViewpointResourceHandler resourceHandler;
    private final BundleListener bundleListener = new SiriusRegistrationBundleListener();

    public PluginMonitor(IExtensionRegistry extensionRegistry, ViewpointResourceHandler resourceType) {
        this.extensionRegistry = (IExtensionRegistry)Preconditions.checkNotNull((Object)extensionRegistry);
        this.resourceHandler = (ViewpointResourceHandler)Preconditions.checkNotNull((Object)resourceType);
    }

    @Override
    public void start() {
        this.running = true;
        this.detectRegisteredVSMs();
        this.registerBundleListener();
    }

    @Override
    public void stop() {
        this.unregisterBundleListener();
        this.running = false;
    }

    private void registerBundleListener() {
        BundleContext context = SiriusPlugin.getDefault().getBundle().getBundleContext();
        context.addBundleListener(this.bundleListener);
    }

    private void unregisterBundleListener() {
        BundleContext context = SiriusPlugin.getDefault().getBundle().getBundleContext();
        context.removeBundleListener(this.bundleListener);
    }

    private void detectRegisteredVSMs() {
        IConfigurationElement[] elements = this.extensionRegistry.getConfigurationElementsFor(VSM_REGISTRATION_EXTENSION_POINT);
        Set<URI> discovered = this.detectRegisteredVSMs(elements);
        this.notifyResourcesEvents(Collections.emptySet(), discovered, Collections.emptySet());
    }

    private Set<URI> findRegisteredVSMs(Bundle bundle) {
        Preconditions.checkNotNull((Object)bundle);
        IContributor contrib = ContributorFactoryOSGi.createContributor((Bundle)bundle);
        IExtension[] extensions = this.extensionRegistry.getExtensions(contrib.getName());
        if (extensions == null) {
            return Collections.emptySet();
        }
        HashSet discovered = Sets.newHashSet();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            if (ext.getExtensionPointUniqueIdentifier().equals(VSM_REGISTRATION_EXTENSION_POINT)) {
                Set<URI> registered = this.detectRegisteredVSMs(ext.getConfigurationElements());
                discovered.addAll(registered);
            }
            ++n2;
        }
        return discovered;
    }

    private Set<URI> detectRegisteredVSMs(IConfigurationElement[] elements) {
        Preconditions.checkNotNull((Object)elements);
        LinkedHashSet discovered = Sets.newLinkedHashSet();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String contributingPlugin = element.getContributor().getName();
            String localPath = element.getAttribute("path");
            if (localPath == null) {
                this.reportWarning("Missing 'path' attribute for VSM definition in " + contributingPlugin + "; ignoring this definition.");
            } else {
                try {
                    URI uri = URI.createPlatformPluginURI((String)("/" + contributingPlugin + "/" + localPath), (boolean)true);
                    if (!this.pluginResourceExists(contributingPlugin, localPath)) {
                        this.reportWarning("Not resource found at specified location " + uri + " in " + contributingPlugin);
                    } else if (!this.resourceHandler.handles(uri)) {
                        this.reportWarning("Registered resource is not of a supported type: " + uri);
                    } else {
                        boolean newEntry = discovered.add(uri);
                        if (!newEntry) {
                            this.reportWarning("Duplicate registration of " + uri + " in " + contributingPlugin);
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.reportWarning("Invalid 'path' attribute for VSM definition in " + contributingPlugin + "; ignoring this definition.");
                }
            }
            ++n2;
        }
        return discovered;
    }

    private boolean pluginResourceExists(String pluginId, String localPath) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            return FileLocator.find((Bundle)bundle, (IPath)new Path(localPath), null) != null;
        }
        return false;
    }

    private void reportWarning(String message) {
        SiriusPlugin.getDefault().warning(message, null);
    }

    private final class SiriusRegistrationBundleListener
    implements BundleListener {
        private SiriusRegistrationBundleListener() {
        }

        public void bundleChanged(BundleEvent event) {
            Bundle bundle = event.getBundle();
            switch (event.getType()) {
                case 1: {
                    this.addAllRegisteredVSMs(bundle);
                    break;
                }
                case 16: {
                    this.removeAllRegisteredVSMs(bundle);
                    break;
                }
            }
        }

        private void addAllRegisteredVSMs(Bundle bundle) {
            Set discovered = PluginMonitor.this.findRegisteredVSMs(bundle);
            PluginMonitor.this.notifyResourcesEvents(Collections.emptySet(), discovered, Collections.emptySet());
        }

        private void removeAllRegisteredVSMs(Bundle bundle) {
            Set discovered = PluginMonitor.this.findRegisteredVSMs(bundle);
            PluginMonitor.this.notifyResourcesEvents(discovered, Collections.emptySet(), Collections.emptySet());
        }
    }
}

