/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEExtensionRegistry;

public class RequirementHelper {
    public static String[] getApplicationRequirements(ILaunchConfiguration config) throws CoreException {
        HashSet<String> requiredIds = new HashSet<String>();
        if (config.getAttribute("useProduct", false)) {
            String product = config.getAttribute("product", null);
            if (product != null) {
                RequirementHelper.getProductRequirements(product, requiredIds);
            }
        } else {
            String configType = config.getType().getIdentifier();
            if (configType.equals("org.eclipse.pde.ui.RuntimeWorkbench")) {
                String application = config.getAttribute("application", TargetPlatform.getDefaultApplication());
                if (!"org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
                    RequirementHelper.getApplicationRequirements(application, requiredIds);
                }
            } else {
                String application = config.getAttribute("testApplication", null);
                if (application == null) {
                    application = config.getAttribute("application", null);
                }
                if (application == null) {
                    application = TargetPlatform.getDefaultApplication();
                }
                if (!"org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
                    RequirementHelper.getApplicationRequirements(application, requiredIds);
                }
            }
        }
        return requiredIds.toArray(new String[requiredIds.size()]);
    }

    private static void getProductRequirements(String product, Collection<String> requiredIds) {
        IExtension[] extensions;
        PDEExtensionRegistry registry = PDECore.getDefault().getExtensionsRegistry();
        IExtension[] iExtensionArray = extensions = registry.findExtensions("org.eclipse.core.runtime.products", true);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (product.equals(extension.getUniqueIdentifier()) || product.equals(extension.getSimpleIdentifier())) {
                IConfigurationElement[] elements;
                requiredIds.add(extension.getNamespaceIdentifier());
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    String application = element.getAttribute("application");
                    if (application != null && application.length() > 0) {
                        RequirementHelper.getApplicationRequirements(application, requiredIds);
                    }
                    ++n4;
                }
                break;
            }
            ++n2;
        }
    }

    private static void getApplicationRequirements(String application, Collection<String> requiredIds) {
        IExtension[] extensions;
        PDEExtensionRegistry registry = PDECore.getDefault().getExtensionsRegistry();
        IExtension[] iExtensionArray = extensions = registry.findExtensions("org.eclipse.core.runtime.applications", true);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (application.equals(extension.getUniqueIdentifier()) || application.equals(extension.getSimpleIdentifier())) {
                requiredIds.add(extension.getNamespaceIdentifier());
                break;
            }
            ++n2;
        }
    }
}

