/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.memory;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.views.memory.PropertyChangeNotifier;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public abstract class AbstractMemoryRendering
extends PlatformObject
implements IMemoryRendering {
    private IMemoryBlock fMemoryBlock;
    private IMemoryRenderingContainer fContainer;
    private ListenerList<IPropertyChangeListener> fPropertyListeners;
    private boolean fVisible = true;
    private MenuManager fPopupMenuMgr;
    private String fRenderingId;
    private ILabelDecorator fLabelDecorator;
    private IMenuListener fMenuListener;

    public AbstractMemoryRendering(String renderingId) {
        this.fRenderingId = renderingId;
    }

    @Override
    public void init(IMemoryRenderingContainer container, IMemoryBlock block) {
        this.fContainer = container;
        this.fMemoryBlock = block;
        this.fLabelDecorator = (ILabelDecorator)this.fMemoryBlock.getAdapter(ILabelDecorator.class);
    }

    @Override
    public void dispose() {
        if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((IMemoryBlockExtension)AbstractMemoryRendering.this.fMemoryBlock).disconnect((Object)AbstractMemoryRendering.this);
                }
            };
            new ConnectionJob(runnable).schedule();
        }
        if (this.fPopupMenuMgr != null) {
            this.fPopupMenuMgr.removeMenuListener(this.fMenuListener);
            this.fPopupMenuMgr.removeAll();
            this.fPopupMenuMgr.dispose();
            this.fPopupMenuMgr = null;
        }
        if (this.fPropertyListeners != null) {
            this.fPropertyListeners = null;
        }
    }

    @Override
    public void activated() {
        if (this.fContainer.getMemoryRenderingSite().getSynchronizationService() != null) {
            this.fContainer.getMemoryRenderingSite().getSynchronizationService().setSynchronizationProvider(this);
        }
    }

    @Override
    public void deactivated() {
    }

    @Override
    public void becomesVisible() {
        this.fVisible = true;
        if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((IMemoryBlockExtension)AbstractMemoryRendering.this.fMemoryBlock).connect((Object)AbstractMemoryRendering.this);
                }
            };
            new ConnectionJob(runnable).schedule();
        }
    }

    @Override
    public void becomesHidden() {
        this.fVisible = false;
        if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((IMemoryBlockExtension)AbstractMemoryRendering.this.fMemoryBlock).disconnect((Object)AbstractMemoryRendering.this);
                }
            };
            new ConnectionJob(runnable).schedule();
        }
    }

    @Override
    public IMemoryBlock getMemoryBlock() {
        return this.fMemoryBlock;
    }

    @Override
    public String getRenderingId() {
        return this.fRenderingId;
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fPropertyListeners == null) {
            this.fPropertyListeners = new ListenerList();
        }
        this.fPropertyListeners.add((Object)listener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fPropertyListeners == null) {
            return;
        }
        this.fPropertyListeners.remove((Object)listener);
    }

    @Override
    public Image getImage() {
        return this.decorateImage(null);
    }

    protected Image decorateImage(Image image) {
        if (this.fLabelDecorator != null) {
            return this.fLabelDecorator.decorateImage(image, (Object)this);
        }
        return image;
    }

    @Override
    public String getLabel() {
        String preName;
        IMemoryRenderingType type;
        if (this.fMemoryBlock == null) {
            return "";
        }
        StringBuffer label = new StringBuffer("");
        if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
            String expression = ((IMemoryBlockExtension)this.fMemoryBlock).getExpression();
            if (expression == null) {
                expression = "";
            }
            label.append(expression);
            if (expression.startsWith("&")) {
                label.insert(0, "&");
            }
            try {
                if (this.fVisible && ((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress() != null) {
                    label.append(" : 0x");
                    label.append(((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress().toString(16).toUpperCase());
                }
            }
            catch (DebugException debugException) {}
        } else {
            long address = this.fMemoryBlock.getStartAddress();
            label.append(Long.toHexString(address).toUpperCase());
        }
        if ((type = DebugUITools.getMemoryRenderingManager().getRenderingType(this.getRenderingId())) != null && (preName = type.getLabel()) != null) {
            label.append(" <");
            label.append(preName);
            label.append(">");
        }
        return this.decorateLabel(label.toString());
    }

    protected String decorateLabel(String label) {
        if (this.fLabelDecorator != null) {
            return this.fLabelDecorator.decorateText(label.toString(), (Object)this);
        }
        return label.toString();
    }

    protected void createPopupMenu(Control control) {
        if (this.fPopupMenuMgr == null) {
            this.fPopupMenuMgr = new MenuManager("#PopupMenu");
            this.fPopupMenuMgr.setRemoveAllWhenShown(true);
            IMemoryRenderingSite site = this.fContainer.getMemoryRenderingSite();
            String menuId = this.fContainer.getId();
            ISelectionProvider selProvider = site.getSite().getSelectionProvider();
            this.fMenuListener = new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    manager.add((IContributionItem)new Separator("additions"));
                }
            };
            this.fPopupMenuMgr.addMenuListener(this.fMenuListener);
            site.getSite().registerContextMenu(menuId, this.fPopupMenuMgr, selProvider);
        }
        Menu popupMenu = this.fPopupMenuMgr.createContextMenu(control);
        control.setMenu(popupMenu);
    }

    protected MenuManager getPopupMenuManager() {
        return this.fPopupMenuMgr;
    }

    protected void firePropertyChangedEvent(PropertyChangeEvent event) {
        if (this.fPropertyListeners == null) {
            return;
        }
        for (IPropertyChangeListener iPropertyChangeListener : this.fPropertyListeners) {
            PropertyChangeNotifier notifier = new PropertyChangeNotifier(iPropertyChangeListener, event);
            SafeRunner.run((ISafeRunnable)notifier);
        }
    }

    public IMemoryRenderingContainer getMemoryRenderingContainer() {
        return this.fContainer;
    }

    public boolean isVisible() {
        return this.fVisible;
    }

    private class ConnectionJob
    extends Job {
        Runnable fRunnable;

        ConnectionJob(Runnable runnable) {
            super("Connect/Disconnect MemoryBlock");
            this.fRunnable = runnable;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.fRunnable.run();
            return Status.OK_STATUS;
        }
    }
}

