/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.trace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MessageEventKind implements Enumerator
{
    INSTANTIATED(0, "INSTANTIATED", "INSTANTIATED"),
    TRANSMITTED(1, "TRANSMITTED", "TRANSMITTED"),
    RECEIVED(2, "RECEIVED", "RECEIVED"),
    ERROR(3, "ERROR", "ERROR");

    public static final int INSTANTIATED_VALUE = 0;
    public static final int TRANSMITTED_VALUE = 1;
    public static final int RECEIVED_VALUE = 2;
    public static final int ERROR_VALUE = 3;
    private static final MessageEventKind[] VALUES_ARRAY;
    public static final List<MessageEventKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MessageEventKind[]{INSTANTIATED, TRANSMITTED, RECEIVED, ERROR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MessageEventKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageEventKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageEventKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageEventKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageEventKind get(int value) {
        switch (value) {
            case 0: {
                return INSTANTIATED;
            }
            case 1: {
                return TRANSMITTED;
            }
            case 2: {
                return RECEIVED;
            }
            case 3: {
                return ERROR;
            }
        }
        return null;
    }

    private MessageEventKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

