/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.ResolutionGenerator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class MultiFixResolution
extends WorkbenchMarkerResolution {
    IMarker fMarker;
    String fLabel;
    boolean problemViewQuickFix;

    public MultiFixResolution(IMarker marker, String label) {
        this.fMarker = marker;
        this.fLabel = label != null ? label : PDEUIMessages.MultiFixResolution_FixAll;
        this.problemViewQuickFix = false;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> relatedMarkers = new ArrayList<IMarker>();
        try {
            String markerCategory = (String)this.fMarker.getAttribute("categoryId");
            int i = 0;
            while (i < markers.length) {
                if (markerCategory.equals(markers[i].getAttribute("categoryId")) && !markers[i].equals((Object)this.fMarker) && markers[i].getResource().equals((Object)this.fMarker.getResource())) {
                    relatedMarkers.add(markers[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        this.problemViewQuickFix = true;
        return relatedMarkers.toArray(new IMarker[relatedMarkers.size()]);
    }

    public String getDescription() {
        return this.getLabel();
    }

    public Image getImage() {
        return PDEPluginImages.DESC_ADD_ATT.createImage();
    }

    public String getLabel() {
        return this.fLabel;
    }

    public void run(IMarker marker) {
        IResource resource = marker.getResource();
        IMarker[] markers = new IMarker[]{};
        try {
            markers = resource.findMarkers(marker.getType(), true, 2);
        }
        catch (CoreException coreException) {}
        if (!this.problemViewQuickFix) {
            IMarker[] otherMarkers = this.findOtherMarkers(markers);
            int i = 0;
            while (i < otherMarkers.length) {
                this.fixMarker(otherMarkers[i]);
                ++i;
            }
        }
        this.fixMarker(marker);
    }

    private void fixMarker(IMarker marker) {
        ResolutionGenerator resGen = new ResolutionGenerator();
        IMarkerResolution[] resolutions = resGen.getResolutions(marker);
        int i = 0;
        while (i < resolutions.length) {
            IMarkerResolution resolution = resolutions[i];
            if (!(resolution instanceof MultiFixResolution)) {
                resolution.run(marker);
                break;
            }
            ++i;
        }
    }

    public boolean equals(Object obj) {
        String categoryId;
        block4: {
            if (!(obj instanceof MultiFixResolution)) {
                return false;
            }
            MultiFixResolution multiFix = (MultiFixResolution)((Object)obj);
            try {
                categoryId = (String)multiFix.fMarker.getAttribute("categoryId");
                if (categoryId != null) break block4;
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return categoryId.equals(this.fMarker.getAttribute("categoryId"));
    }

    public int hashCode() {
        try {
            String category = (String)this.fMarker.getAttribute("categoryId");
            return category.hashCode();
        }
        catch (CoreException coreException) {
            return super.hashCode();
        }
    }
}

