/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.modelexplorer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;

public class SiriusDialectLinkWithEditorSelectionListener
implements ISelectionChangedListener,
IPropertyListener,
IPartListener2 {
    private CommonNavigator navigator;
    private IPartService partService;
    private Collection<DialectEditor> registeredEditors;

    public SiriusDialectLinkWithEditorSelectionListener(CommonNavigator navigator) {
        this.navigator = navigator;
        this.registeredEditors = new ArrayList<DialectEditor>();
    }

    public void init() {
        if (this.navigator != null) {
            this.navigator.addPropertyListener((IPropertyListener)this);
            this.partService = this.getPartService();
            if (this.navigator.isLinkingEnabled()) {
                this.enableSelectionListener();
            }
        }
    }

    public void dispose() {
        this.disableSelectionListener();
        this.navigator = null;
        this.partService = null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            if (event.getSource() != this.getActivePartSource()) {
                return;
            }
            if (event.getSource().equals(this.navigator.getCommonViewer())) {
                IWorkbenchPage page = EclipseUIUtil.getActivePage();
                IEditorPart activeEditor = page.getActiveEditor();
                if (activeEditor instanceof DialectEditor) {
                    DialectEditor dialectEditor = (DialectEditor)activeEditor;
                    page.bringToTop((IWorkbenchPart)dialectEditor);
                    this.selectRepresentationElements(selection, dialectEditor);
                }
            } else {
                Set<EObject> targets = this.getTargetsFromSelection((IStructuredSelection)selection);
                if (!targets.isEmpty()) {
                    this.navigator.selectReveal((ISelection)new StructuredSelection(targets.toArray()));
                }
            }
        }
    }

    private Object getActivePartSource() {
        IWorkbenchPart part;
        IWorkbenchPart toReturn = part = this.partService.getActivePart();
        if (part instanceof DialectEditor) {
            toReturn = ((DialectEditor)part).getEditorSite().getSelectionProvider();
        } else if (part instanceof CommonNavigator) {
            toReturn = ((CommonNavigator)part).getCommonViewer();
        }
        return toReturn;
    }

    private void selectRepresentationElements(ISelection selection, DialectEditor dialectEditor) {
        List<DRepresentationElement> representationElements = this.getRepresentationElements(dialectEditor.getRepresentation(), ((IStructuredSelection)selection).toList());
        DialectUIManager.INSTANCE.selectAndReveal(dialectEditor, representationElements);
    }

    private List<DRepresentationElement> getRepresentationElements(DRepresentation representation, List<?> selection) {
        ArrayList result = Lists.newArrayList();
        if (representation != null) {
            for (DRepresentationElement element : representation.getRepresentationElements()) {
                if (selection == null || !selection.contains(element.getTarget())) continue;
                result.add(element);
            }
        }
        return result;
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 65536) {
            if (this.navigator.isLinkingEnabled()) {
                this.enableSelectionListener();
            } else {
                this.disableSelectionListener();
            }
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof DialectEditor && this.registeredEditors.contains(part)) {
            this.removeSelectionListener((DialectEditor)part);
            this.registeredEditors.remove(part);
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof DialectEditor && !this.registeredEditors.contains(part)) {
            this.addSelectionListener((DialectEditor)part);
            this.registeredEditors.add((DialectEditor)part);
        }
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    private Set<EObject> getTargetsFromSelection(IStructuredSelection iStructuredSelection) {
        HashSet<EObject> targets = new HashSet<EObject>();
        for (Object element : iStructuredSelection) {
            DSemanticDecorator decorator = null;
            if (element instanceof DSemanticDecorator) {
                decorator = (DSemanticDecorator)element;
            } else if (element instanceof IAdaptable) {
                decorator = (DSemanticDecorator)((IAdaptable)element).getAdapter(DSemanticDecorator.class);
            }
            if (decorator == null) continue;
            if (decorator instanceof DRepresentation) {
                targets.add((EObject)new DRepresentationQuery((DRepresentation)decorator).getRepresentationDescriptor());
                continue;
            }
            targets.add(decorator.getTarget());
        }
        return targets;
    }

    private void addSelectionListener(DialectEditor editor) {
        ISelectionProvider selectionProvider;
        if (editor != null && editor.getEditorSite() != null && (selectionProvider = editor.getEditorSite().getSelectionProvider()) != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    private IPartService getPartService() {
        IViewSite site = this.navigator.getViewSite();
        if (site != null) {
            return (IPartService)site.getService(IPartService.class);
        }
        return null;
    }

    private void enableSelectionListener() {
        if (this.partService != null) {
            IEditorReference[] editorReferences;
            this.navigator.getCommonViewer().addSelectionChangedListener((ISelectionChangedListener)this);
            this.partService.addPartListener((IPartListener2)this);
            IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                IEditorPart editorPart = editorReference.getEditor(false);
                if (editorPart instanceof DialectEditor) {
                    this.addSelectionListener((DialectEditor)editorPart);
                    this.registeredEditors.add((DialectEditor)editorPart);
                }
                ++n2;
            }
        }
    }

    private void disableSelectionListener() {
        if (this.partService != null) {
            this.navigator.getCommonViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
            this.partService.removePartListener((IPartListener2)this);
            for (DialectEditor dialectEditor : this.registeredEditors) {
                this.removeSelectionListener(dialectEditor);
            }
            this.registeredEditors.clear();
        }
    }

    private void removeSelectionListener(DialectEditor dialectEditor) {
        ISelectionProvider selectionProvider;
        if (dialectEditor != null && dialectEditor.getEditorSite() != null && (selectionProvider = dialectEditor.getEditorSite().getSelectionProvider()) != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }
}

