/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.editor;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.SessionSpecificEditorInput;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class SpecificEditorInputTranformer {
    private static final String SESSION_FILE_EXTENSION = ".aird";
    private static final String DEFAULT_FILE_NAME = Messages.SpecificEditorInputTranformer_defaultFileName;
    protected Session session;
    private RepresentationDescription description;
    private URI mySiriusURI;
    private String myRepresentationDescriptionName;
    private Viewpoint viewpoint;

    public void init(URI viewpointURI, String representationDescriptionName) {
        this.mySiriusURI = viewpointURI;
        this.myRepresentationDescriptionName = representationDescriptionName;
        this.viewpoint = this.getSirius(viewpointURI);
        this.description = this.getRepresentationDescription(representationDescriptionName);
    }

    private Viewpoint getSirius(URI viewpointURI) {
        return ViewpointRegistry.getInstance().getViewpoint(viewpointURI);
    }

    private RepresentationDescription getRepresentationDescription(String wantedName) {
        for (RepresentationDescription representationDescription : this.viewpoint.getOwnedRepresentations()) {
            if (!wantedName.equals(representationDescription.getName())) continue;
            return representationDescription;
        }
        throw new RuntimeException();
    }

    public void cleanEnvironment() {
        if (this.session != null) {
            this.session.close((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public IEditorInput transformInput(IEditorInput input, ISelection selection, boolean storeInWorkspace) {
        if (!(input instanceof URIEditorInput) && input instanceof IFileEditorInput) {
            if (this.session != null) {
                this.cleanEnvironment();
            }
            IPath semanticModelPath = ((IFileEditorInput)input).getFile().getFullPath();
            try {
                String analysisFilenameURI = this.getAnalysisURI(selection, storeInWorkspace).toString();
                DRepresentation representation = this.createSessionAndRepresentation(semanticModelPath, analysisFilenameURI);
                return this.createNewEditorInput(representation, semanticModelPath);
            }
            catch (IOException exception) {
                SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", Messages.SpecificEditorInputTranformer_transformationFailure, (Throwable)exception));
            }
            catch (CoreException exception) {
                SiriusEditPlugin.getPlugin().getLog().log(exception.getStatus());
            }
        }
        return input;
    }

    public DRepresentation createSessionAndRepresentation(IPath semanticModelPath, String analysisFilenameURI) throws IOException, CoreException {
        URI sessionModelURI = URI.createURI((String)analysisFilenameURI);
        IFile semanticModelFile = ResourcesPlugin.getWorkspace().getRoot().getFile(semanticModelPath);
        URI semanticModelURI = URI.createPlatformResourceURI((String)semanticModelFile.getFullPath().toOSString(), (boolean)true);
        DefaultLocalSessionCreationOperation coreOp = new DefaultLocalSessionCreationOperation(sessionModelURI, (IProgressMonitor)new NullProgressMonitor());
        coreOp.execute();
        this.session = coreOp.getCreatedSession();
        AddSemanticResourceCommand addSemanticResourceCommand = new AddSemanticResourceCommand(this.session, semanticModelURI, (IProgressMonitor)new NullProgressMonitor());
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)addSemanticResourceCommand);
        EObject semanticModel = (EObject)((Resource)this.session.getSemanticResources().iterator().next()).getContents().get(0);
        this.activateSirius();
        return this.createDRepresentation(semanticModel, Messages.SpecificEditorInputTranformer_newRepresentationName);
    }

    private DRepresentation createDRepresentation(EObject semanticModel, String name) {
        RepresentationDescription descriptionToUse = this.getRepresentationDescriptionInEditingDomain(this.description, semanticModel);
        Option<DRepresentation> optionalRepresentation = this.findRepresentation(descriptionToUse, semanticModel);
        if (optionalRepresentation.some()) {
            return (DRepresentation)optionalRepresentation.get();
        }
        CreateRepresentationCommand command = new CreateRepresentationCommand(this.session, descriptionToUse, semanticModel, name, (IProgressMonitor)new NullProgressMonitor());
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
        return command.getCreatedRepresentation();
    }

    private Option<DRepresentation> findRepresentation(RepresentationDescription representationDescriptionUsed, EObject semanticElement) {
        if (this.session != null && representationDescriptionUsed != null && semanticElement != null) {
            for (DView view : this.session.getOwnedViews()) {
                for (DRepresentation repr : new DViewQuery(view).getLoadedRepresentations()) {
                    RepresentationDescription reprDesc = DialectManager.INSTANCE.getDescription(repr);
                    if (!(repr instanceof DSemanticDecorator) || !representationDescriptionUsed.equals(reprDesc) || !semanticElement.equals(((DSemanticDecorator)repr).getTarget())) continue;
                    return Options.newSome((Object)repr);
                }
            }
        }
        return Options.newNone();
    }

    private RepresentationDescription getRepresentationDescriptionInEditingDomain(RepresentationDescription representationDescription, EObject semanticModel) {
        Collection representationDescriptions = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(this.session.getSelectedViewpoints(false), semanticModel);
        for (RepresentationDescription representationDescriptionInEditingDomain : representationDescriptions) {
            if (!representationDescriptionInEditingDomain.getName().equals(representationDescription.getName())) continue;
            return representationDescriptionInEditingDomain;
        }
        return null;
    }

    private IEditorInput createNewEditorInput(DRepresentation representation, IPath semanticModelPath) {
        String editorName = DialectUIManager.INSTANCE.getEditorName(representation);
        URI uri = this.getNewEditorInputURI(representation);
        SessionSpecificEditorInput input = new SessionSpecificEditorInput(uri, editorName, this.session);
        input.init(semanticModelPath, this.mySiriusURI, this.myRepresentationDescriptionName);
        return input;
    }

    protected URI getNewEditorInputURI(DRepresentation representation) {
        return EcoreUtil.getURI((EObject)representation);
    }

    private void activateSirius() {
        ViewpointSelectionCallback selectionCallback = new ViewpointSelectionCallback();
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new ChangeViewpointSelectionCommand(this.session, selectionCallback, (Set)Sets.newHashSet((Object[])new Viewpoint[]{this.viewpoint}), Sets.newHashSet(), (IProgressMonitor)new NullProgressMonitor()){

            public boolean canUndo() {
                return false;
            }
        });
    }

    protected URI getAnalysisURI(ISelection selection, boolean storeInWorkspace) throws IOException {
        if (storeInWorkspace) {
            return this.getWorkspaceAnalysisUri(selection);
        }
        return this.getInMemoryURI(selection);
    }

    protected URI getWorkspaceAnalysisUri(ISelection selection) {
        IPath path;
        IResource selectedResource = this.getSelectedResource(selection);
        if (selectedResource instanceof IFile && (path = this.getWorkspacePath(selectedResource)) != null) {
            String fileName = String.valueOf(((IFile)selectedResource).getName()) + SESSION_FILE_EXTENSION;
            return URI.createPlatformResourceURI((String)path.append(fileName).toString(), (boolean)true);
        }
        return URI.createURI((String)(String.valueOf(DEFAULT_FILE_NAME) + SESSION_FILE_EXTENSION));
    }

    protected URI getTempAnalysisURI() throws IOException {
        File temp = File.createTempFile(DEFAULT_FILE_NAME, SESSION_FILE_EXTENSION);
        temp.deleteOnExit();
        return URI.createFileURI((String)temp.getAbsolutePath());
    }

    protected URI getInMemoryURI(ISelection selection) {
        IResource selectedResource = this.getSelectedResource(selection);
        if (selectedResource instanceof IFile) {
            String sessionResourcePath = selectedResource.getFullPath().removeFileExtension().addFileExtension("aird").makeRelative().toString();
            return URI.createGenericURI((String)"memory", (String)sessionResourcePath, null);
        }
        return URI.createGenericURI((String)"memory", (String)(String.valueOf(DEFAULT_FILE_NAME) + SESSION_FILE_EXTENSION), null);
    }

    private IPath getWorkspacePath(IResource resource) {
        IPath path = null;
        if (resource instanceof IContainer) {
            path = ((IContainer)resource).getFullPath();
        } else if (resource instanceof IFile) {
            path = ((IFile)resource).getParent().getFullPath();
        }
        return path;
    }

    private IResource getSelectedResource(ISelection selection) {
        IResource resource = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object element = ss.getFirstElement();
            if (element instanceof IResource) {
                resource = (IResource)element;
            } else if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                Object adapter = adaptable.getAdapter(IResource.class);
                resource = (IResource)adapter;
            }
        }
        return resource;
    }
}

