/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.dialect;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.graphics.Image;

public class HierarchyLabelProvider
extends LabelProvider {
    private static final String DELIMITER = " > ";
    private ILabelProvider wrappedProvider;

    public HierarchyLabelProvider(ILabelProvider wrappedProvider) {
        this.wrappedProvider = wrappedProvider;
    }

    public Image getImage(Object element) {
        return this.wrappedProvider != null ? this.wrappedProvider.getImage(element) : super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof EObject && this.handles((EObject)element)) {
            LinkedList segments = Lists.newLinkedList();
            EObject current = (EObject)element;
            while (current != null) {
                segments.addFirst(this.getLabel(current));
                current = current.eContainer();
            }
            return Joiner.on((String)this.getDelimiter()).join((Iterable)segments);
        }
        return this.wrappedProvider != null ? this.wrappedProvider.getText(element) : super.getText(element);
    }

    protected boolean handles(EObject element) {
        return true;
    }

    protected String getDelimiter() {
        return DELIMITER;
    }

    protected String getDefaultLabel() {
        return Messages.HierarchyLabelProvider_elementWihtoutNameLabel;
    }

    private String getLabel(EObject eObject) {
        String label = this.getDefaultLabel();
        label = eObject instanceof IdentifiedElement ? new IdentifiedElementQuery((IdentifiedElement)eObject).getLabel() : (eObject instanceof RepresentationExtensionDescription ? ((RepresentationExtensionDescription)eObject).getName() : this.wrappedProvider.getText((Object)eObject));
        return label;
    }

    public void dispose() {
        if (this.wrappedProvider != null) {
            this.wrappedProvider.dispose();
            this.wrappedProvider = null;
        }
        super.dispose();
    }
}

