/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.base.collect;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SetIntersection<E> {
    Map<Integer, E> newElements = new HashMap<Integer, E>();
    Map<Integer, E> keptElements = new HashMap<Integer, E>();
    Map<Integer, E> removedElements = new HashMap<Integer, E>();
    List<E> duplicateOldElements;
    Map<Integer, E> allElements = new LinkedHashMap<Integer, E>();

    public SetIntersection() {
        this.duplicateOldElements = Lists.newArrayList();
    }

    public void addInOld(E newObj) {
        assert (newObj != null);
        Integer hash = newObj.hashCode();
        if (this.newElements.containsKey(hash)) {
            E removed = this.newElements.remove(hash);
            this.keptElements.put(hash, removed);
        } else if (this.removedElements.containsKey(hash)) {
            this.duplicateOldElements.add(newObj);
        } else {
            this.removedElements.put(hash, newObj);
        }
    }

    public void addInNew(E newObj) {
        assert (newObj != null);
        Integer hash = newObj.hashCode();
        if (this.removedElements.containsKey(hash)) {
            E removed = this.removedElements.remove(hash);
            this.keptElements.put(hash, removed);
            this.allElements.put(hash, removed);
        } else if (!this.keptElements.containsKey(hash)) {
            this.newElements.put(hash, newObj);
            this.allElements.put(hash, newObj);
        }
    }

    public Collection<E> getNewElements() {
        return this.newElements.values();
    }

    public Iterable<E> getKeptElements() {
        return this.keptElements.values();
    }

    public Iterable<E> getRemovedElements() {
        ArrayList result = Lists.newArrayList(this.removedElements.values());
        if (this.duplicateOldElements != null && !this.duplicateOldElements.isEmpty()) {
            result.addAll(this.duplicateOldElements);
        }
        return result;
    }

    public Iterable<E> getAllElements() {
        return this.allElements.values();
    }
}

