/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsRewriteOperations;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class NullAnnotationsFix
extends CompilationUnitRewriteOperationsFix {
    private CompilationUnit cu;

    public NullAnnotationsFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] operations) {
        super(name, compilationUnit, operations);
        this.cu = compilationUnit;
    }

    public CompilationUnit getCu() {
        return this.cu;
    }

    public static boolean isComplainingAboutArgument(ASTNode selectedNode) {
        if (!(selectedNode instanceof SimpleName)) {
            return false;
        }
        SimpleName nameNode = (SimpleName)selectedNode;
        IBinding binding = nameNode.resolveBinding();
        if (binding.getKind() == 3 && ((IVariableBinding)binding).isParameter()) {
            return true;
        }
        VariableDeclaration argDecl = (VariableDeclaration)ASTNodes.getParent(selectedNode, VariableDeclaration.class);
        if (argDecl != null) {
            binding = argDecl.resolveBinding();
        }
        return binding.getKind() == 3 && ((IVariableBinding)binding).isParameter();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isComplainingAboutReturn(ASTNode selectedNode) {
        if (selectedNode.getParent().getNodeType() != 41) ** GOTO lbl6
        return true;
lbl-1000:
        // 1 sources

        {
            if (selectedNode == null) {
                return false;
            }
            selectedNode = selectedNode.getParent();
lbl6:
            // 2 sources

            ** while (!(selectedNode instanceof Type))
        }
lbl7:
        // 1 sources

        return selectedNode.getLocationInParent() == MethodDeclaration.RETURN_TYPE2_PROPERTY;
    }

    public static NullAnnotationsFix createNullAnnotationInSignatureFix(CompilationUnit compilationUnit, IProblemLocation problem, NullAnnotationsRewriteOperations.ChangeKind changeKind, boolean isArgumentProblem) {
        String nullableAnnotationName = NullAnnotationsFix.getNullableAnnotationName(compilationUnit.getJavaElement(), false);
        String nonNullAnnotationName = NullAnnotationsFix.getNonNullAnnotationName(compilationUnit.getJavaElement(), false);
        String annotationToAdd = nullableAnnotationName;
        String annotationToRemove = nonNullAnnotationName;
        switch (problem.getProblemId()) {
            case 67109779: 
            case 67109780: {
                if (changeKind != NullAnnotationsRewriteOperations.ChangeKind.OVERRIDDEN) break;
                annotationToAdd = nonNullAnnotationName;
                annotationToRemove = nullableAnnotationName;
                break;
            }
            case 67109778: 
            case 67109781: {
                if (changeKind == NullAnnotationsRewriteOperations.ChangeKind.OVERRIDDEN) break;
                annotationToAdd = nonNullAnnotationName;
                annotationToRemove = nullableAnnotationName;
                break;
            }
            case 16778126: 
            case 16778127: 
            case 16778128: 
            case 536871845: {
                if (isArgumentProblem != (changeKind != NullAnnotationsRewriteOperations.ChangeKind.TARGET)) break;
                annotationToAdd = nonNullAnnotationName;
                annotationToRemove = nullableAnnotationName;
                break;
            }
            case 67109803: 
            case 67109804: {
                if (changeKind != NullAnnotationsRewriteOperations.ChangeKind.INVERSE) break;
                annotationToAdd = nonNullAnnotationName;
                annotationToRemove = nullableAnnotationName;
            }
        }
        NullAnnotationsRewriteOperations.SignatureAnnotationRewriteOperation operation = NullAnnotationsRewriteOperations.createAddAnnotationOperation(compilationUnit, problem, annotationToAdd, annotationToRemove, null, false, true, isArgumentProblem, changeKind);
        if (operation == null) {
            return null;
        }
        if (annotationToAdd == nonNullAnnotationName) {
            operation.fRemoveIfNonNullByDefault = true;
            operation.fNonNullByDefaultName = NullAnnotationsFix.getNonNullByDefaultAnnotationName(compilationUnit.getJavaElement(), false);
        }
        return new NullAnnotationsFix(operation.getMessage(), operation.getCompilationUnit(), new NullAnnotationsRewriteOperations.SignatureAnnotationRewriteOperation[]{operation});
    }

    public static NullAnnotationsFix createRemoveRedundantNullAnnotationsFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        NullAnnotationsRewriteOperations.RemoveRedundantAnnotationRewriteOperation operation = new NullAnnotationsRewriteOperations.RemoveRedundantAnnotationRewriteOperation(compilationUnit, problem);
        return new NullAnnotationsFix(FixMessages.NullAnnotationsRewriteOperations_remove_redundant_nullness_annotation, compilationUnit, new NullAnnotationsRewriteOperations.RemoveRedundantAnnotationRewriteOperation[]{operation});
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] locations, int problemID) {
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (!JavaModelUtil.is50OrHigher(cu.getJavaProject())) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation>();
        if (locations == null) {
            IProblem[] problems = compilationUnit.getProblems();
            locations = new IProblemLocation[problems.length];
            int i = 0;
            while (i < problems.length) {
                if (problems[i].getID() == problemID) {
                    locations[i] = new ProblemLocation(problems[i]);
                }
                ++i;
            }
        }
        NullAnnotationsFix.createAddNullAnnotationOperations(compilationUnit, locations, operations);
        NullAnnotationsFix.createRemoveRedundantNullAnnotationsOperations(compilationUnit, locations, operations);
        if (operations.size() == 0) {
            return null;
        }
        CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] operationsArray = operations.toArray(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[operations.size()]);
        return new NullAnnotationsFix(FixMessages.NullAnnotationsFix_add_annotation_change_name, compilationUnit, operationsArray);
    }

    private static void createAddNullAnnotationOperations(CompilationUnit compilationUnit, IProblemLocation[] locations, List<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> result) {
        String nullableAnnotationName = NullAnnotationsFix.getNullableAnnotationName(compilationUnit.getJavaElement(), false);
        String nonNullAnnotationName = NullAnnotationsFix.getNonNullAnnotationName(compilationUnit.getJavaElement(), false);
        HashSet<String> handledPositions = new HashSet<String>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation problem = locations[i];
            if (problem != null) {
                boolean isArgumentProblem = NullAnnotationsFix.isComplainingAboutArgument(problem.getCoveredNode(compilationUnit));
                String annotationToAdd = nullableAnnotationName;
                String annotationToRemove = nonNullAnnotationName;
                switch (problem.getProblemId()) {
                    case 67109779: 
                    case 67109780: {
                        break;
                    }
                    case 67109778: 
                    case 67109781: {
                        annotationToAdd = nonNullAnnotationName;
                        annotationToRemove = nullableAnnotationName;
                        break;
                    }
                    case 16778126: 
                    case 16778127: 
                    case 16778128: 
                    case 536871845: {
                        if (!isArgumentProblem) break;
                        annotationToAdd = nonNullAnnotationName;
                        annotationToRemove = nullableAnnotationName;
                    }
                }
                NullAnnotationsRewriteOperations.SignatureAnnotationRewriteOperation fix = NullAnnotationsRewriteOperations.createAddAnnotationOperation(compilationUnit, problem, annotationToAdd, annotationToRemove, handledPositions, true, false, isArgumentProblem, NullAnnotationsRewriteOperations.ChangeKind.LOCAL);
                if (fix != null) {
                    if (annotationToAdd == nonNullAnnotationName) {
                        fix.fRemoveIfNonNullByDefault = true;
                        fix.fNonNullByDefaultName = NullAnnotationsFix.getNonNullByDefaultAnnotationName(compilationUnit.getJavaElement(), false);
                    }
                    result.add(fix);
                }
            }
            ++i;
        }
    }

    private static void createRemoveRedundantNullAnnotationsOperations(CompilationUnit compilationUnit, IProblemLocation[] locations, List<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> result) {
        int i = 0;
        while (i < locations.length) {
            int problemId;
            IProblemLocation problem = locations[i];
            if (problem != null && ((problemId = problem.getProblemId()) == 67109786 || problemId == 536871838 || problemId == 536871839 || problemId == 536871840)) {
                NullAnnotationsRewriteOperations.RemoveRedundantAnnotationRewriteOperation operation = new NullAnnotationsRewriteOperations.RemoveRedundantAnnotationRewriteOperation(compilationUnit, problem);
                result.add(operation);
            }
            ++i;
        }
    }

    public static boolean hasExplicitNullAnnotation(ICompilationUnit compilationUnit, int offset) {
        return false;
    }

    public static String getNullableAnnotationName(IJavaElement javaElement, boolean makeSimple) {
        return NullAnnotationsFix.getAnnotationName(javaElement, makeSimple, "org.eclipse.jdt.core.compiler.annotation.nullable");
    }

    public static String getNonNullAnnotationName(IJavaElement javaElement, boolean makeSimple) {
        return NullAnnotationsFix.getAnnotationName(javaElement, makeSimple, "org.eclipse.jdt.core.compiler.annotation.nonnull");
    }

    public static String getNonNullByDefaultAnnotationName(IJavaElement javaElement, boolean makeSimple) {
        return NullAnnotationsFix.getAnnotationName(javaElement, makeSimple, "org.eclipse.jdt.core.compiler.annotation.nonnullbydefault");
    }

    private static String getAnnotationName(IJavaElement javaElement, boolean makeSimple, String annotation) {
        int lastDot;
        String qualifiedName = javaElement.getJavaProject().getOption(annotation, true);
        if (makeSimple && qualifiedName != null && (lastDot = qualifiedName.lastIndexOf(46)) != -1) {
            return qualifiedName.substring(lastDot + 1);
        }
        return qualifiedName;
    }
}

