/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.views.providers.layers;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.palette.PaletteManager;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.TabbarRefresher;

public class LayersActivationAdapter
extends AdapterImpl {
    private StructuredViewer viewer;
    private PaletteManager paletteManager;

    public void setViewer(Viewer viewer) {
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
        }
    }

    public void setPaletteManager(PaletteManager paletteManager) {
        this.paletteManager = paletteManager;
    }

    private void update(DDiagram diagram, final Layer layer, final boolean activate, final boolean isTransient) {
        EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (LayersActivationAdapter.this.viewer != null) {
                    LayersActivationAdapter.this.viewer.update((Object)layer, null);
                }
                if (LayersActivationAdapter.this.paletteManager != null) {
                    if (activate) {
                        LayersActivationAdapter.this.paletteManager.showLayer(layer);
                    } else {
                        LayersActivationAdapter.this.paletteManager.hideLayer(layer);
                    }
                }
                if (isTransient) {
                    TabbarRefresher.reinitToolbar();
                }
            }
        });
    }

    public void notifyChanged(Notification msg) {
        int featureID;
        Object notifier = msg.getNotifier();
        if (notifier instanceof DDiagram && ((featureID = msg.getFeatureID(DDiagram.class)) == 22 || featureID == 17)) {
            switch (msg.getEventType()) {
                case 3: {
                    Layer layerToAdd = (Layer)msg.getNewValue();
                    this.update((DDiagram)notifier, layerToAdd, true, featureID == 17);
                    break;
                }
                case 4: {
                    Layer layerToRemove = (Layer)msg.getOldValue();
                    this.update((DDiagram)notifier, layerToRemove, false, featureID == 17);
                    break;
                }
            }
        }
    }
}

