/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.part;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;

public class SemanticElementToEditPartsMap {
    private Map<EObject, List<EditPart>> map = new WeakHashMap<EObject, List<EditPart>>();

    public <T extends EditPart> List<T> findEditPartsForElement(EObject element, Class<T> editPartClass) {
        List<EditPart> allEPs = this.map.get(element);
        if (allEPs == null) {
            return Collections.emptyList();
        }
        ArrayList specificEPs = Lists.newArrayList();
        for (EditPart ep : allEPs) {
            if (!editPartClass.isInstance(ep)) continue;
            specificEPs.add(ep);
        }
        return specificEPs;
    }

    public void registerEditPartForElement(EObject element, EditPart ep) {
        if (element == null || ep == null) {
            return;
        }
        List<EditPart> epList = this.map.get(element);
        if (epList != null) {
            if (!epList.contains(ep)) {
                epList.add(ep);
            }
        } else {
            ArrayList<EditPart> newList = new ArrayList<EditPart>(1);
            newList.add(ep);
            this.map.put(element, newList);
        }
    }

    public void unregisterEditPartForElement(EObject element, EditPart ep) {
        if (element == null || ep == null) {
            return;
        }
        List<EditPart> epList = this.map.get(element);
        if (epList != null && epList.contains(ep)) {
            epList.remove(ep);
            if (epList.isEmpty()) {
                this.map.remove(element);
            }
        }
    }

    public void unregisterEditPart(EditPart ep) {
        ArrayList keysToRemove = Lists.newArrayList();
        for (Map.Entry<EObject, List<EditPart>> entry : this.map.entrySet()) {
            boolean remove;
            List<EditPart> epList = entry.getValue();
            if (epList == null || !(remove = epList.remove(ep)) || !epList.isEmpty()) continue;
            keysToRemove.add(entry.getKey());
        }
        if (!keysToRemove.isEmpty()) {
            for (EObject danglingKey : keysToRemove) {
                this.map.remove(danglingKey);
            }
        }
    }
}

