/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import org.eclipse.gef.Disposable;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.FormColors;

public class TabbarToolBarManager
extends ToolBarManager {
    private IWorkbenchPart tabbarPart;
    private Image fGradientBackground;

    public TabbarToolBarManager(ToolBar toolBar, IWorkbenchPart part) {
        super(toolBar);
        this.tabbarPart = part;
    }

    public void add(IAction action) {
        super.add(action);
        if (action instanceof IDisposableAction) {
            ((IDisposableAction)action).init();
        }
    }

    protected void itemRemoved(IContributionItem item) {
        if (item instanceof ActionContributionItem) {
            IAction action = ((ActionContributionItem)item).getAction();
            if (action instanceof IDisposableAction) {
                ((IDisposableAction)action).dispose();
            } else if (action instanceof ActionFactory.IWorkbenchAction) {
                ((ActionFactory.IWorkbenchAction)action).dispose();
            } else if (action instanceof Disposable) {
                ((Disposable)action).dispose();
            }
        }
        item.dispose();
    }

    public void update(boolean force) {
        IWorkbenchPage activePage = this.getSafeActivePage();
        if (activePage != null && this.tabbarPart instanceof DDiagramEditor && activePage.getActivePart() != this.tabbarPart && this.getControl().getItems().length > 0) {
            return;
        }
        super.update(force);
        this.updateGradientBackground();
    }

    private IWorkbenchPage getSafeActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            return activeWorkbenchWindow.getActivePage();
        }
        return null;
    }

    protected void updateGradientBackground() {
        if (this.getControl() == null) {
            return;
        }
        int height = this.getControl().getClientArea().height;
        if (height > 0 && (this.fGradientBackground == null || this.fGradientBackground.getBounds().height != height)) {
            Image image = this.createGradientImage(height, Display.getCurrent());
            this.getControl().setBackgroundImage(image);
            if (this.fGradientBackground != null) {
                this.fGradientBackground.dispose();
            }
            this.fGradientBackground = image;
        }
    }

    private Image createGradientImage(int height, Display display) {
        int width = 50;
        Image result = new Image((Device)display, width, height);
        GC gc = new GC((Drawable)result);
        Color colorC = this.createColor(22, 25, 35, display);
        Color colorD = this.createColor(22, 25, 45, display);
        Color colorE = this.createColor(22, 25, 80, display);
        Color colorF = this.createColor(22, 25, 70, display);
        Color colorG = this.createColor(22, 1, 45, display);
        Color colorH = this.createColor(18, 25, 35, display);
        try {
            this.drawLine(width, 0, colorC, gc);
            this.drawLine(width, 1, colorC, gc);
            gc.setForeground(colorD);
            gc.setBackground(colorE);
            gc.fillGradientRectangle(0, 2, width, 10, true);
            gc.setBackground(colorE);
            gc.fillRectangle(0, 11, width, height - 4);
            this.drawLine(width, height - 3, colorF, gc);
            this.drawLine(width, height - 2, colorG, gc);
            this.drawLine(width, height - 1, colorH, gc);
        }
        finally {
            gc.dispose();
            colorC.dispose();
            colorD.dispose();
            colorE.dispose();
            colorF.dispose();
            colorG.dispose();
            colorH.dispose();
        }
        return result;
    }

    private void drawLine(int width, int position, Color color, GC gc) {
        gc.setForeground(color);
        gc.drawLine(0, position, width, position);
    }

    private Color createColor(int color1, int color2, int ratio, Display display) {
        RGB rgb1 = display.getSystemColor(color1).getRGB();
        RGB rgb2 = display.getSystemColor(color2).getRGB();
        RGB blend = FormColors.blend((RGB)rgb2, (RGB)rgb1, (int)ratio);
        return new Color((Device)display, blend);
    }

    public void dispose() {
        super.dispose();
        this.tabbarPart = null;
        if (this.fGradientBackground != null) {
            this.fGradientBackground.dispose();
            this.fGradientBackground = null;
        }
    }
}

