/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.hrm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ReplPolicy implements Enumerator
{
    LRU(0, "lru", "lru"),
    NFU(1, "nfu", "nfu"),
    FIFO(2, "fifo", "fifo"),
    RANDOM(3, "random", "random"),
    OTHER(4, "other", "other"),
    UNDEF(5, "undef", "undef");

    public static final int LRU_VALUE = 0;
    public static final int NFU_VALUE = 1;
    public static final int FIFO_VALUE = 2;
    public static final int RANDOM_VALUE = 3;
    public static final int OTHER_VALUE = 4;
    public static final int UNDEF_VALUE = 5;
    private static final ReplPolicy[] VALUES_ARRAY;
    public static final List<ReplPolicy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ReplPolicy[]{LRU, NFU, FIFO, RANDOM, OTHER, UNDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ReplPolicy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ReplPolicy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ReplPolicy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ReplPolicy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ReplPolicy get(int value) {
        switch (value) {
            case 0: {
                return LRU;
            }
            case 1: {
                return NFU;
            }
            case 2: {
                return FIFO;
            }
            case 3: {
                return RANDOM;
            }
            case 4: {
                return OTHER;
            }
            case 5: {
                return UNDEF;
            }
        }
        return null;
    }

    private ReplPolicy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

