/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.provider;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;

public class DTreeItemDragListener
extends DragSourceAdapter
implements DragSourceListener {
    private ISelectionProvider selectionProvider;

    public DTreeItemDragListener(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    public void dragFinished(DragSourceEvent event) {
    }

    public void dragSetData(DragSourceEvent event) {
        ISelection selection = this.selectionProvider.getSelection();
        if (selection instanceof IStructuredSelection) {
            LinkedHashSet dragData = Sets.newLinkedHashSet();
            for (Object selectedElement : (IStructuredSelection)selection) {
                if (!(selectedElement instanceof DTreeItem)) continue;
                dragData.add((DTreeItem)selectedElement);
            }
            LocalSelectionTransfer.getTransfer().setSelection(this.selectionProvider.getSelection());
            event.data = dragData;
        }
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = !this.selectionProvider.getSelection().isEmpty();
    }
}

