/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.NoteAttachmentEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ExecutionEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.LifelineEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.figure.SequenceSlidableAnchor;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.EditPartsHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.ui.internal.view.factories.ViewLocationHint;

public final class ConnectionAnchorOperation {
    private ConnectionAnchorOperation() {
    }

    public static ConnectionAnchor getHorizontallyCenteredAnchor(ConnectionAnchor anchor) {
        return ConnectionAnchorOperation.getCorrectedAnchor(anchor, null, 0.5);
    }

    public static ConnectionAnchor getHorizontallyCenteredAndTopAnchor(ConnectionAnchor anchor) {
        return ConnectionAnchorOperation.getCorrectedAnchor(anchor, "(0.5,0)", 0.5);
    }

    public static ConnectionAnchor getHorizontallyCenteredAndBottomAnchor(ConnectionAnchor anchor) {
        return ConnectionAnchorOperation.getCorrectedAnchor(anchor, "(0.5,1)", 0.5);
    }

    private static ConnectionAnchor getCorrectedAnchor(ConnectionAnchor anchor, String defaultId, double preciseX) {
        Object result = anchor;
        if (anchor instanceof SlidableAnchor) {
            PrecisionPoint pp;
            String id = ((SlidableAnchor)anchor).getTerminal();
            if (StringUtil.isEmpty((String)id) && !StringUtil.isEmpty((String)defaultId)) {
                id = defaultId;
            }
            if (!StringUtil.isEmpty((String)id) && (pp = BaseSlidableAnchor.parseTerminalString((String)id)) != null) {
                pp.setPreciseX(preciseX);
                result = new SequenceSlidableAnchor(anchor, pp);
            }
        }
        return result;
    }

    public static void matchRequestYLocationWithSourceAnchor(DropRequest request) {
        Object sourceLocation;
        if (request instanceof Request && !new RequestQuery((Request)request).isSequenceMessageCreation()) {
            return;
        }
        if (request.getLocation() != null && (sourceLocation = ViewLocationHint.getInstance().getData((Object)"sourceConnectionAnchorLocation")) instanceof Point && request instanceof CreateConnectionRequest) {
            EditPart sourceEP = ((CreateConnectionRequest)request).getSourceEditPart();
            EditPart targetEP = ((CreateConnectionRequest)request).getTargetEditPart();
            Point sourceLocationPoint = ((Point)sourceLocation).getCopy();
            if (!sourceEP.equals(targetEP)) {
                request.getLocation().y = sourceLocationPoint.y;
            } else if (request.getLocation().y <= sourceLocationPoint.y) {
                request.getLocation().y = sourceLocationPoint.y;
            }
        }
    }

    public static ConnectionAnchor getSourceConnectionAnchor(ISequenceEventEditPart self, Request request, ConnectionAnchor superSourceAnchor) {
        CreateConnectionRequest ccr;
        ConnectionAnchor result = ConnectionAnchorOperation.getHorizontallyCenteredAnchor(superSourceAnchor);
        if (request instanceof CreateConnectionRequest && (ccr = (CreateConnectionRequest)request).getLocation() == null) {
            result = ConnectionAnchorOperation.getHorizontallyCenteredAndBottomAnchor(superSourceAnchor);
        }
        return result;
    }

    public static ConnectionAnchor getTargetConnectionAnchor(ISequenceEventEditPart self, Request request, ConnectionAnchor superTargetAnchor) {
        ConnectionAnchor result = ConnectionAnchorOperation.getHorizontallyCenteredAnchor(superTargetAnchor);
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest ccr = (CreateConnectionRequest)request;
            result = ConnectionAnchorOperation.isCreateMessageToSelfRequest(ccr) ? ConnectionAnchorOperation.getHorizontallyCenteredAndTopAnchor(superTargetAnchor) : ConnectionAnchorOperation.getHorizontallyCenteredAnchor(superTargetAnchor);
        } else if (request instanceof ReconnectRequest && !(((ReconnectRequest)request).getConnectionEditPart() instanceof NoteAttachmentEditPart)) {
            ReconnectRequest conn = (ReconnectRequest)request;
            ConnectionEditPart cep = (ConnectionEditPart)conn.getConnectionEditPart();
            result = cep.getConnectionFigure().getTargetAnchor();
        } else {
            result = superTargetAnchor;
        }
        return result;
    }

    private static boolean isCreateMessageToSelfRequest(CreateConnectionRequest ccr) {
        if ((ccr.getSourceEditPart() instanceof ExecutionEditPart || ccr.getSourceEditPart() instanceof LifelineEditPart) && (ccr.getTargetEditPart() instanceof ExecutionEditPart || ccr.getTargetEditPart() instanceof LifelineEditPart)) {
            LifelineEditPart sourceParentLifeline = EditPartsHelper.findParentLifeline((IGraphicalEditPart)ccr.getSourceEditPart());
            LifelineEditPart targetParentLifeline = EditPartsHelper.findParentLifeline((IGraphicalEditPart)ccr.getTargetEditPart());
            return sourceParentLifeline.equals(targetParentLifeline);
        }
        return false;
    }

    public static ConnectionAnchor safeCenterAnchor(ConnectionAnchor anchor) {
        Object result = anchor;
        if (result != null) {
            result = new SequenceSlidableAnchor(anchor, new PrecisionPoint(0.5, 0.5));
        }
        return result;
    }
}

